/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectoroverlayoperators.OmsVectorOverlayOperators;

@Description(value="A module that performs overlay operations on a pure geometric layer. The resulting feature layer does not consider original attributes tables.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="JTS, Overlay, Union, Intersect, SymDifference, Difference")
@Label(value="Vector Processing")
@Name(value="_overlay")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class VectorOverlayOperators
extends HMModel {
    @Description(value="The first vector map.")
    @UI(value="infile_vector")
    @In
    public String inMap1 = null;
    @Description(value="The second vector map.")
    @UI(value="infile_vector")
    @In
    public String inMap2 = null;
    @Description(value="The overlay type to perform.")
    @UI(value="combo:intersection,union,difference,symdifference")
    @In
    public String pType = "intersection";
    @Description(value="The resulting vector map.")
    @UI(value="outfile")
    @In
    public String outMap = null;

    @Execute
    public void process() throws Exception {
        OmsVectorOverlayOperators vectoroverlayoperators = new OmsVectorOverlayOperators();
        vectoroverlayoperators.inMap1 = this.getVector(this.inMap1);
        vectoroverlayoperators.inMap2 = this.getVector(this.inMap2);
        vectoroverlayoperators.pType = this.pType;
        vectoroverlayoperators.pm = this.pm;
        vectoroverlayoperators.doProcess = this.doProcess;
        vectoroverlayoperators.doReset = this.doReset;
        vectoroverlayoperators.process();
        this.dumpVector(vectoroverlayoperators.outMap, this.outMap);
    }
}

