/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import java.io.FilenameFilter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectorreprojector.OmsVectorReprojector;
import org.hortonmachine.gears.utils.DataUtilities;

@Description(value="Module for vector reprojection.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="CRS, Reprojection, Vector")
@Label(value="Vector Processing")
@Name(value="_vreproject")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class VectorReprojector
extends HMModel {
    @Description(value="The vector that has to be reprojected.")
    @UI(value="infile_vector")
    @In
    public String inVector;
    @Description(value="The code defining the target coordinate reference system, composed by authority and code number (ex. EPSG:4328).")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="A flag to modify the axes order.")
    @In
    public Boolean doLongitudeFirst = null;
    @Description(value="A coordinate reference system on which to force the input, composed by authority and code number (ex. EPSG:4328).")
    @UI(value="crs")
    @In
    public String pForceCode;
    @Description(value="Switch that set to true allows for some error due to different datums. If set to false, it won't reproject without Bursa Wolf parameters.")
    @In
    public boolean doLenient = true;
    @Description(value="The output reprojected vector.")
    @UI(value="outfile")
    @In
    public String outVector = null;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inVector, this.outVector});
        File inVectorFile = new File(this.inVector);
        if (inVectorFile.isDirectory()) {
            File[] listFiles = inVectorFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return DataUtilities.isSupportedVectorExtension((String)name);
                }
            });
            File outVectorFolder = new File(this.outVector);
            if (!outVectorFolder.isDirectory()) {
                outVectorFolder = outVectorFolder.getParentFile();
            }
            for (File inFile : listFiles) {
                String name = inFile.getName();
                File outFile = new File(outVectorFolder, name);
                OmsVectorReprojector vectorreprojector = new OmsVectorReprojector();
                vectorreprojector.inVector = this.getVector(inFile.getAbsolutePath());
                vectorreprojector.pCode = this.pCode;
                vectorreprojector.doLongitudeFirst = this.doLongitudeFirst;
                vectorreprojector.pForceCode = this.pForceCode;
                vectorreprojector.doLenient = this.doLenient;
                vectorreprojector.pm = this.pm;
                vectorreprojector.doProcess = this.doProcess;
                vectorreprojector.doReset = this.doReset;
                vectorreprojector.process();
                this.dumpVector(vectorreprojector.outVector, outFile.getAbsolutePath());
            }
        } else {
            OmsVectorReprojector vectorreprojector = new OmsVectorReprojector();
            vectorreprojector.inVector = this.getVector(this.inVector);
            vectorreprojector.pCode = this.pCode;
            vectorreprojector.doLongitudeFirst = this.doLongitudeFirst;
            vectorreprojector.pForceCode = this.pForceCode;
            vectorreprojector.doLenient = this.doLenient;
            vectorreprojector.pm = this.pm;
            vectorreprojector.doProcess = this.doProcess;
            vectorreprojector.doReset = this.doReset;
            vectorreprojector.process();
            this.dumpVector(vectorreprojector.outVector, this.outVector);
        }
    }
}

