/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.triangulation.OmsDelaunayTriangulation;

@Description(value="Creates a Delaunay triangulation from a set of points.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="vector, delaunay, triangulation")
@Label(value="Vector Processing")
@Name(value="delaunaytriangulation")
@Status(value=40)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class DelaunayTriangulation
extends HMModel {
    @Description(value="The input points map.")
    @UI(value="infile_vector")
    @In
    public String inMap = null;
    @Description(value="The optional name of the field containing the elevation value.")
    @In
    public String fElev = "elev";
    @Description(value="The output triangles map.")
    @UI(value="outfile")
    @In
    public String outMap = null;

    @Execute
    public void process() throws Exception {
        OmsDelaunayTriangulation delaunayTriangulation = new OmsDelaunayTriangulation();
        delaunayTriangulation.pm = this.pm;
        delaunayTriangulation.inMap = this.getVector(this.inMap);
        delaunayTriangulation.fElev = this.fElev;
        delaunayTriangulation.process();
        this.dumpVector(delaunayTriangulation.outMap, this.outMap);
    }
}

