/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import java.util.HashMap;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.io.timeseries.OmsTimeSeriesReader;
import org.hortonmachine.gears.io.timeseries.OmsTimeSeriesWriter;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.peakflow.OmsPeakflow;

@Description(value="The OmsPeakflow semidistributed hydrologic model.")
@Author(name="Silvia Franceschi, Andrea Antonello, Riccardo Rigon", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="OmsPeakflow, Discharge, Hydrologic, OmsCb, RescaledDistance")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="_peakflow")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Peakflow
extends HMModel {
    @Description(value="The a parameter for statistic rain calculations.")
    @Unit(value="mm/h^m")
    @In
    public double pA = -1.0;
    @Description(value="The n parameter for statistic rain calculations.")
    @In
    public double pN = -1.0;
    @Description(value="The channel celerity parameter.")
    @Unit(value="m/s")
    @In
    public double pCelerity = -1.0;
    @Description(value="The diffusion parameter.")
    @Unit(value="m2/s")
    @In
    public double pDiffusion = -1.0;
    @Description(value="The saturation percentage.")
    @Unit(value="%")
    @In
    public double pSat = -1.0;
    @Description(value="The output timestep for discharge.")
    @Unit(value="s")
    @In
    public double pOutputStepArg = 60.0;
    @Description(value="The map of Topindex.")
    @UI(value="infile_raster")
    @In
    public String inTopindex = null;
    @Description(value="Optional map of saturation.")
    @UI(value="infile_raster")
    @In
    public String inSat = null;
    @Description(value="The map of superficial rescaled distance.")
    @UI(value="infile_raster")
    @In
    public String inRescaledsup = null;
    @Description(value="The map of sub-superficial rescaled distance.")
    @UI(value="infile_raster")
    @In
    public String inRescaledsub = null;
    @Description(value="The oms csv of rainfall data per timestep.")
    @UI(value="infile_csv")
    @In
    public String inRainfall;
    @Description(value="The oms csv of peakflow output per timestep.")
    @UI(value="outfile")
    @In
    public String outDischarge;
    public double[][] widthFunctionSuperficial;
    public double[][] widthFunctionSubSuperficial;
    public double[][] volumeCheckMatrix;

    @Execute
    public void process() throws Exception {
        OmsPeakflow peakflow = new OmsPeakflow();
        peakflow.pA = this.pA;
        peakflow.pN = this.pN;
        peakflow.pCelerity = this.pCelerity;
        peakflow.pDiffusion = this.pDiffusion;
        peakflow.pSat = this.pSat;
        peakflow.pOutputStepArg = this.pOutputStepArg;
        peakflow.inTopindex = this.getRaster(this.inTopindex);
        peakflow.inSat = this.getRaster(this.inSat);
        peakflow.inRescaledsup = this.getRaster(this.inRescaledsup);
        peakflow.inRescaledsub = this.getRaster(this.inRescaledsub);
        if (this.inRainfall != null && new File(this.inRainfall).exists()) {
            HashMap outData;
            OmsTimeSeriesReader reader = new OmsTimeSeriesReader();
            reader.file = this.inRainfall;
            reader.fileNovalue = "-9999";
            reader.read();
            peakflow.inRainfall = outData = reader.outData;
        }
        peakflow.pm = this.pm;
        peakflow.doProcess = this.doProcess;
        peakflow.doReset = this.doReset;
        peakflow.process();
        this.widthFunctionSuperficial = peakflow.widthFunctionSuperficial;
        this.widthFunctionSubSuperficial = peakflow.widthFunctionSubSuperficial;
        this.volumeCheckMatrix = peakflow.volumeCheckMatrix;
        OmsTimeSeriesWriter writer = new OmsTimeSeriesWriter();
        writer.columns = "date, discharge";
        writer.file = this.outDischarge;
        writer.doDates = true;
        writer.inData = peakflow.outDischarge;
        writer.tablename = "discharge";
        writer.write();
        writer.close();
    }
}

