/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.gears.io.rasterreader.OmsRasterReader;
import org.hortonmachine.gears.io.vectorwriter.OmsVectorWriter;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.contoursextractor.OmsContourExtractor;

@Description(value="Module that extracts contour lines from a raster.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector")
@Label(value="Vector Processing")
@Name(value="_contourextract")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class ContourExtractor
extends HMModel {
    @Description(value="The raster on which to calculate the contours.")
    @UI(value="infile_raster")
    @In
    public String inCoverage;
    @Description(value="The minimum value for the contours.")
    @In
    public Double pMin;
    @Description(value="The maximum value for the contours.")
    @In
    public Double pMax;
    @Description(value="The contours interval.")
    @In
    public Double pInterval;
    @Description(value="The generated contour lines vector.")
    @UI(value="outfile")
    @In
    public String outGeodata = null;

    @Execute
    public void process() throws Exception {
        OmsContourExtractor ex = new OmsContourExtractor();
        ex.pm = this.pm;
        ex.inCoverage = this.getRaster(this.inCoverage);
        ex.pMin = this.pMin;
        ex.pMax = this.pMax;
        ex.pInterval = this.pInterval;
        ex.process();
        this.dumpVector(ex.outGeodata, this.outGeodata);
    }

    public static void main(String[] args) throws Exception {
        OmsContourExtractor ex = new OmsContourExtractor();
        ex.inCoverage = OmsRasterReader.readRaster((String)"/home/hydrologis/Dropbox/hydrologis/lavori/2018_12_idro_bertani/data/laghetto/laghetto_dtm_5x5.asc");
        ex.pMin = 110.0;
        ex.pMax = 320.0;
        ex.pInterval = 10.0;
        ex.process();
        OmsVectorWriter.writeVector((String)"/home/hydrologis/Dropbox/hydrologis/lavori/2018_12_idro_bertani/data/laghetto/test_contours.shp", (SimpleFeatureCollection)ex.outGeodata);
    }
}

