/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.debristriggers.OmsDebrisTriggerCnr;

@Description(value="Module for extraction of debris trigger points along the network following the CNR methodology.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="Debris, Trigger, Raster")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="_debristrigger")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class DebrisTriggerCnr
extends HMModel {
    @Description(value="The map of elevation.")
    @UI(value="infile_raster")
    @In
    public String inElev = null;
    @Description(value="The map of the network.")
    @UI(value="infile_raster")
    @In
    public String inNet = null;
    @Description(value="The map of tca.")
    @UI(value="infile_raster")
    @In
    public String inTca = null;
    @Description(value="The tca threshold to use (default = 10 km2).")
    @Unit(value="km2")
    @In
    public double pTcathres = 10.0;
    @Description(value="The gradient threshold to use (default = 38 deg).")
    @Unit(value="degree")
    @In
    public double pGradthres = 38.0;
    @Description(value="The trigger map.")
    @UI(value="outfile")
    @In
    public String outTriggers = null;

    @Execute
    public void process() throws Exception {
        OmsDebrisTriggerCnr debristriggercnr = new OmsDebrisTriggerCnr();
        debristriggercnr.inElev = this.getRaster(this.inElev);
        debristriggercnr.inNet = this.getRaster(this.inNet);
        debristriggercnr.inTca = this.getRaster(this.inTca);
        debristriggercnr.pTcathres = this.pTcathres;
        debristriggercnr.pGradthres = this.pGradthres;
        debristriggercnr.pm = this.pm;
        debristriggercnr.doProcess = this.doProcess;
        debristriggercnr.doReset = this.doReset;
        debristriggercnr.process();
        this.dumpRaster(debristriggercnr.outTriggers, this.outTriggers);
    }
}

