/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.geomorphology.gradient.OmsGradient;

@Description(value="Calculates the gradient in each point of the map.")
@Author(name="Daniele Andreis, Antonello Andrea, Erica Ghesla, Cozzini Andrea, Franceschi Silvia, Pisoni Silvano, Rigon Riccardo", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Geomorphology, OmsDrainDir, OmsFlowDirections, OmsSlope, OmsCurvatures")
@Label(value="HortonMachine/Geomorphology")
@Name(value="_gradient")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Gradient
extends HMModel {
    @Description(value="The map of the digital elevation model (DEM or pit).")
    @UI(value="infile_raster")
    @In
    public String inElev = null;
    @Description(value="The gradient formula mode.")
    @UI(value="combo:Finite Differences,Horn,Evans")
    @In
    public String pMode = "Finite Differences";
    @Description(value="The output type, if false = tan of the angle (default), if true = degrees")
    @In
    public boolean doDegrees = false;
    @Description(value="The map of gradient.")
    @UI(value="outfile")
    @In
    public String outSlope = null;

    @Execute
    public void process() throws Exception {
        OmsGradient gradient = new OmsGradient();
        gradient.inElev = this.getRaster(this.inElev);
        gradient.pMode = this.pMode;
        gradient.doDegrees = this.doDegrees;
        gradient.pm = this.pm;
        gradient.doProcess = this.doProcess;
        gradient.doReset = this.doReset;
        gradient.process();
        this.dumpRaster(gradient.outSlope, this.outSlope);
    }
}

