/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.intensityclassifier.OmsHazardClassifier;

@Description(value="Hazard classifier.")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Flooding, Hazard")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="hazardclassifier")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class HazardClassifier
extends HMModel {
    @Description(value="Intensity map for Tr=200 years.")
    @UI(value="infile_raster")
    @In
    public String inIntensityTr200;
    @Description(value="Intensity map for Tr=100 years.")
    @UI(value="infile_raster")
    @In
    public String inIntensityTr100;
    @Description(value="Intensity map for Tr=30 years.")
    @UI(value="infile_raster")
    @In
    public String inIntensityTr30;
    @Description(value="Output hazard map IP1")
    @UI(value="outfile")
    @In
    public String outHazardIP1 = null;
    @UI(value="outfile")
    @Description(value="Output hazard map IP2")
    @In
    public String outHazardIP2 = null;

    @Execute
    public void process() throws Exception {
        OmsHazardClassifier classifier = new OmsHazardClassifier();
        classifier.inIntensityTr200 = this.getRaster(this.inIntensityTr200);
        classifier.inIntensityTr100 = this.getRaster(this.inIntensityTr100);
        classifier.inIntensityTr30 = this.getRaster(this.inIntensityTr30);
        classifier.pm = this.pm;
        classifier.process();
        this.dumpRaster(classifier.outHazardIP1, this.outHazardIP1);
        this.dumpRaster(classifier.outHazardIP2, this.outHazardIP2);
    }
}

