/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.lwrecruitment.OmsLW09_NetworBufferMergerHolesRemover;

@Description(value="Merge the inundated polygons to avoid strange perimeters.")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="network, vector, bankflull, inundation")
@Label(value="HortonMachine/Hydro-Geomorphology/LWRecruitment")
@Name(value="_lw09_networbuffermergerholesremover")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LW09_NetworBufferMergerHolesRemover
extends HMModel {
    @Description(value="The input polygon layer with the inundation polygons.")
    @UI(value="infile_vector")
    @In
    public String inInundationArea = null;
    @Description(value="The output polygon layer with the merged and without holes inundation polygons.")
    @UI(value="outfile")
    @In
    public String outInundationArea = null;

    @Execute
    public void process() throws Exception {
        OmsLW09_NetworBufferMergerHolesRemover bufferMergerHolesRemover = new OmsLW09_NetworBufferMergerHolesRemover();
        bufferMergerHolesRemover.inInundationArea = this.getVector(this.inInundationArea);
        bufferMergerHolesRemover.pm = this.pm;
        bufferMergerHolesRemover.process();
        this.dumpVector(bufferMergerHolesRemover.outInundationArea, this.outInundationArea);
    }
}

