/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.geomorphology.flow.OmsLeastCostFlowDirections;

@Description(value="Calculates the drainage directions following the least cost method.")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Geomorphology, Flowdirections, Least cost")
@Label(value="HortonMachine/Geomorphology")
@Name(value="_flowlc")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LeastCostFlowDirections
extends HMModel {
    @Description(value="The elevation map.")
    @UI(value="infile_raster")
    @In
    public String inElev = null;
    @Description(value="Flag to toggle tca calculation.")
    @In
    public boolean doTca = true;
    @Description(value="Flag to toggle slope calculation.")
    @In
    public boolean doSlope = true;
    @Description(value="Flag to toggle aspect calculation.")
    @In
    public boolean doAspect = true;
    @Description(value="The map of flowdirections.")
    @UI(value="outfile")
    @In
    public String outFlow = null;
    @Description(value="The map of tca (optional).")
    @UI(value="outfile")
    @In
    public String outTca = null;
    @Description(value="The map of aspect (optional).")
    @UI(value="outfile")
    @In
    public String outAspect = null;
    @Description(value="The map of slope (optional).")
    @UI(value="outfile")
    @In
    public String outSlope = null;

    @Execute
    public void process() throws Exception {
        OmsLeastCostFlowDirections leastcostflowdirections = new OmsLeastCostFlowDirections();
        leastcostflowdirections.inElev = this.getRaster(this.inElev);
        leastcostflowdirections.doTca = this.outTca != null;
        leastcostflowdirections.doSlope = this.outSlope != null;
        leastcostflowdirections.doAspect = this.outAspect != null;
        leastcostflowdirections.pm = this.pm;
        leastcostflowdirections.doProcess = this.doProcess;
        leastcostflowdirections.doReset = this.doReset;
        leastcostflowdirections.process();
        this.dumpRaster(leastcostflowdirections.outFlow, this.outFlow);
        this.dumpRaster(leastcostflowdirections.outTca, this.outTca);
        this.dumpRaster(leastcostflowdirections.outAspect, this.outAspect);
        this.dumpRaster(leastcostflowdirections.outSlope, this.outSlope);
    }
}

