/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectorize.OmsPointsVectorizer;

@Description(value="Module that creates a points vector layer from raster values.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector")
@Label(value="Vector Processing")
@Name(value="_pvectorizer")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class PointsVectorizer
extends HMModel {
    @Description(value="The raster that has to be converted.")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="The field name to use as a name for the raster value in the vector.")
    @In
    public String fDefault = "value";
    @Description(value="The extracted vector.")
    @UI(value="outfile")
    @In
    public String outVector = null;

    @Execute
    public void process() throws Exception {
        OmsPointsVectorizer pointsvectorizer = new OmsPointsVectorizer();
        pointsvectorizer.inRaster = this.getRaster(this.inRaster);
        pointsvectorizer.fDefault = this.fDefault;
        pointsvectorizer.pm = this.pm;
        pointsvectorizer.doProcess = this.doProcess;
        pointsvectorizer.doReset = this.doReset;
        pointsvectorizer.process();
        this.dumpVector(pointsvectorizer.outVector, this.outVector);
    }
}

