/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.scanline.OmsScanLineRasterizer;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;

@Description(value="Adds a value from a vector layer over a raster layer.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="vector, raster, add")
@Label(value="Raster Processing")
@Name(value="rasterextruder")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class RasterExtruder
extends HMModel {
    @Description(value="The input raster to modify.")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="The input vector with the values to add.")
    @UI(value="infile_vector")
    @In
    public String inVector;
    @Description(value="The field containing the value to add from the vector map.")
    @In
    public String pAddingField;
    @Description(value="The output raster.")
    @UI(value="outfile")
    @In
    public String outRaster;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inRaster, this.inVector, this.pAddingField});
        GridCoverage2D dtm = this.getRaster(this.inRaster);
        SimpleFeatureCollection vector = this.getVector(this.inVector);
        OmsScanLineRasterizer r = new OmsScanLineRasterizer();
        r.inRaster = dtm;
        r.inVector = vector;
        r.fCat = this.pAddingField;
        r.process();
        GridCoverage2D outGC = r.outRaster;
        GridCoverage2D mergedGC = CoverageUtilities.mergeCoverages((GridCoverage2D)outGC, (GridCoverage2D)dtm);
        this.dumpRaster(mergedGC, this.outRaster);
    }
}

