/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.basin.rescaleddistance.OmsRescaledDistance;

@Description(value="Calculates the rescaled distance of each pixel from the outlet.")
@Author(name="Antonello Andrea, Franceschi Silvia, Daniele Andreis,  Erica Ghesla, Cozzini Andrea, Pisoni Silvano, Rigon Riccardo", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Basin, Geomorphology, D2O")
@Label(value="HortonMachine/Basin")
@Name(value="_rescdist")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class RescaledDistance
extends HMModel {
    @Description(value="The map of flowdirections.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The map of the network.")
    @UI(value="infile_raster")
    @In
    public String inNet = null;
    @Description(value="The optional map of elevation for 3D.")
    @UI(value="infile_raster")
    @In
    public String inElev = null;
    @Description(value="Ratio between the velocity in the channel and in the hillslope.")
    @In
    public double pRatio = 0.0;
    @Description(value="The map of the rescaled distances.")
    @UI(value="outfile")
    @In
    public String outRescaled = null;

    @Execute
    public void process() throws Exception {
        OmsRescaledDistance rescaleddistance = new OmsRescaledDistance();
        rescaleddistance.inFlow = this.getRaster(this.inFlow);
        rescaleddistance.inNet = this.getRaster(this.inNet);
        rescaleddistance.inElev = this.getRaster(this.inElev);
        rescaleddistance.pRatio = this.pRatio;
        rescaleddistance.pm = this.pm;
        rescaleddistance.doProcess = this.doProcess;
        rescaleddistance.doReset = this.doReset;
        rescaleddistance.process();
        this.dumpRaster(rescaleddistance.outRescaled, this.outRescaled);
    }
}

