/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Range;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.io.timeseries.OmsTimeSeriesReader;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.hmachine.modules.networktools.trento_p.OmsTrentoP;
import org.hortonmachine.hmachine.modules.networktools.trento_p.utils.DiametersReader;
import org.joda.time.DateTime;

@Description(value="Calculates the diameters of a sewer net or verify the discharge for each pipe.")
@Author(name="Daniele Andreis,Rigon Riccardo,David tamanini", contact="")
@Keywords(value="Sewer network")
@Label(value="Others")
@Name(value="")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class TrentoP
extends HMModel {
    @Description(value="Processing mode, 0=project, 1=verification.")
    @In
    public int pMode;
    @Description(value="Minimum excavation depth")
    @Unit(value="m")
    @In
    public double pMinimumDepth = 1.2;
    @Description(value="Max number of pipes that can converge in a junction.")
    @Unit(value="-")
    @Range(max=6.0, min=0.0)
    @In
    public int pMaxJunction = 4;
    @Description(value="Max number of bisection to do (default is 40)to search a solution of a transcendently equation.")
    @Unit(value="-")
    @Range(max=1000.0, min=3.0)
    @In
    public int pJMax = 40;
    @Description(value="Accuracy to use to calculate a solution with bisection method.")
    @Unit(value="-")
    @Range(min=0.0)
    @In
    public Double pAccuracy = 0.005;
    @Description(value="Accuracy to use to calculate the discharge.")
    @Unit(value="-")
    @Range(max=1.0, min=0.0)
    @In
    public double pEpsilon = 0.001;
    @Description(value="Minimum Fill degree")
    @Unit(value="-")
    @Range(max=0.1, min=0.0)
    @In
    public double pMinG = 0.01;
    @Description(value="Minimum discharge in a pipe")
    @Unit(value="m3/s")
    @Range(min=0.0)
    @In
    public double pMinDischarge = 1.0;
    @Description(value="Maximum Fill degree")
    @Unit(value="-")
    @Range(min=3.141592653589793)
    @In
    public double pMaxTheta = 6.28319;
    @Description(value="Celerity factor, value used to obtain the celerity of the discharge wave.")
    @Unit(value="-")
    @Range(min=1.0, max=1.6)
    @In
    public double pCelerityFactor = 1.0;
    @Description(value="Exponent of the basin extension. Used to calculate the average acces time to the network.")
    @Unit(value="-")
    @Range(min=0.0)
    @In
    public double pExponent = 0.3;
    @Description(value="tollerance, used to obtain the radius")
    @Unit(value="-")
    @Range(min=0.0)
    @In
    public double pTolerance = 1.0E-4;
    @Description(value="Division base to height in the rectangular or trapezium section.")
    @Unit(value="-")
    @Range(min=0.0)
    @In
    public double pC = 1.0;
    @Description(value="Exponent of the average ponderal slope of a basin to calculate the average access time to the network  for area units.")
    @Unit(value="-")
    @Range(min=0.0)
    @In
    public double pGamma = 0.2;
    @Description(value="Exponent of the influx coefficent to calculate the average residence time in the network .")
    @Unit(value="-")
    @Range(min=0.0)
    @In
    public double pEspInflux = 0.4;
    @Description(value="Minimum dig depth, for rectangular or trapezium pipe.")
    @Unit(value="m")
    @Range(min=0.0)
    @In
    public double pFranco = 0.5;
    @Description(value=" Coefficient of the pluviometric curve of possibility.")
    @Unit(value="-")
    @Range(min=0.0)
    @In
    public Double pA;
    @Description(value="Exponent of the pluviometric curve of possibility. ")
    @Unit(value="-")
    @Range(min=0.05, max=0.95)
    @In
    public Double pN;
    @Description(value="Tangential bottom stress, which ensure the self-cleaning of the network.")
    @Unit(value="N/m2")
    @Range(min=0.0)
    @In
    public Double pTau;
    @Description(value="Fill degree to use during the project.")
    @Unit(value="-")
    @Range(min=0.0, max=0.99)
    @In
    public Double pG;
    @Description(value="Align mode, it can be 0 (so the free surface is aligned through a change in the depth of the pipes) or 1 (aligned with bottom step).")
    @In
    public Integer pAlign;
    @Description(value="Matrix which contains the commercial diameters of the pipes.")
    @UI(value="infile_csv")
    @In
    public String inDiameters;
    @Description(value="The outlet, the last pipe of the network,.")
    @Unit(value="-")
    @In
    public Integer pOutPipe = null;
    @Description(value="Time step to calculate the discharge in project mode.")
    @Unit(value="-")
    @Range(min=0.015)
    @In
    public double tDTp = 0.25;
    @Description(value="Minimum Rain Time step to calculate the discharge.")
    @Unit(value="-")
    @Range(min=5.0)
    @In
    public double tpMin = 5.0;
    @Description(value="Maximum Rain Time step to calculate the discharge.")
    @Unit(value="minutes")
    @Range(min=30.0)
    @In
    public double tpMax = 120.0;
    @Description(value="Max number of time step.")
    @Unit(value="-")
    @In
    public int tMax = 120;
    @Description(value="Maximum Rain Time step to evaluate the Rain in calibration mode.")
    @Unit(value="minutes")
    @In
    public Integer tpMaxCalibration = null;
    @Description(value="Time step, if pMode=1, in minutes. Is the step used to calculate the discharge. If it's not setted then it's equal to the rain time step.")
    @Unit(value="minutes")
    @In
    public Integer dt;
    @Description(value="rain data.")
    @UI(value="infile_csv")
    @In
    public String inRain = null;
    @Description(value="The read feature collection.")
    @UI(value="infile_vector")
    @In
    public String inPipes = null;
    @Description(value="The output feature collection which contains the net with all hydraulics value.")
    @UI(value="outfile")
    @Out
    public String outPipes = null;
    @Description(value="The output if pTest=1, contains the discharge for each pipes at several time.")
    @UI(value="outfile")
    @Out
    public String outDischarge;
    @Description(value="The output if pTest=1, contains the fill degree for each pipes at several time.")
    @UI(value="outfile")
    @Out
    public String outFillDegree;
    @Description(value="The time which give the maximum discharge.")
    @Unit(value="minutes")
    @Out
    public Integer outTpMax = null;
    private double[][] results;

    @Execute
    public void process() throws Exception {
        StringBuilder sb;
        double[][] outDisch;
        OmsTrentoP trento_P = new OmsTrentoP();
        trento_P.pMode = this.pMode;
        trento_P.pA = this.pA;
        trento_P.pN = this.pN;
        trento_P.pTau = this.pTau;
        trento_P.pG = this.pG;
        trento_P.pAlign = this.pAlign;
        trento_P.pMinimumDepth = this.pMinimumDepth;
        trento_P.pMaxJunction = this.pMaxJunction;
        trento_P.pJMax = this.pJMax;
        trento_P.pAccuracy = this.pAccuracy;
        trento_P.tDTp = this.tDTp;
        trento_P.tpMin = this.tpMin;
        trento_P.tpMax = this.tpMax;
        trento_P.pEpsilon = this.pEpsilon;
        trento_P.pMinG = this.pMinG;
        trento_P.pMinDischarge = this.pMinDischarge;
        trento_P.pMaxTheta = this.pMaxTheta;
        trento_P.pCelerityFactor = this.pCelerityFactor;
        trento_P.pExponent = this.pExponent;
        trento_P.pTolerance = this.pTolerance;
        trento_P.pC = this.pC;
        trento_P.pGamma = this.pGamma;
        trento_P.pEspInflux = this.pEspInflux;
        if (this.inDiameters != null) {
            DiametersReader diametersreader = new DiametersReader();
            diametersreader.file = this.inDiameters;
            diametersreader.pCols = 2;
            diametersreader.pSeparator = "\\s+";
            diametersreader.fileNovalue = "-9999.0";
            diametersreader.readFile();
            trento_P.inDiameters = diametersreader.data;
        }
        trento_P.pOutPipe = this.pOutPipe;
        if (this.inRain != null) {
            OmsTimeSeriesReader rainReader = new OmsTimeSeriesReader();
            rainReader.fileNovalue = "-9999";
            rainReader.file = this.inRain;
            rainReader.read();
            rainReader.close();
            trento_P.inRain = rainReader.outData;
        }
        trento_P.inPipes = this.getVector(this.inPipes);
        trento_P.process();
        this.dumpVector(trento_P.outPipes, this.outPipes);
        this.results = trento_P.getResults();
        if (this.outDischarge != null && trento_P.outDischarge != null) {
            outDisch = this.hashToMatrix(trento_P.outDischarge, this.results.length);
            sb = this.printMatrixData(outDisch);
            FileUtilities.writeFile((String)sb.toString(), (File)new File(this.outDischarge));
        }
        if (this.outFillDegree != null && trento_P.outFillDegree != null) {
            outDisch = this.hashToMatrix(trento_P.outFillDegree, this.results.length);
            sb = this.printMatrixData(outDisch);
            FileUtilities.writeFile((String)sb.toString(), (File)new File(this.outDischarge));
        }
    }

    public double[][] getResults() {
        return this.results;
    }

    private StringBuilder printMatrixData(double[][] matrix) {
        StringBuilder sb = new StringBuilder();
        int cols = matrix[0].length;
        int rows = matrix.length;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                sb.append(matrix[r][c]);
                sb.append(", ");
            }
            sb.append("\n");
        }
        return sb;
    }

    private double[][] hashToMatrix(HashMap<DateTime, HashMap<Integer, double[]>> outDischarge, int nStation) {
        Set<Map.Entry<DateTime, HashMap<Integer, double[]>>> dischargeSet = outDischarge.entrySet();
        DateTime first = null;
        DateTime second = null;
        int l = outDischarge.size();
        double[][] rainData = new double[l][nStation + 1];
        int index = 0;
        int dt = 0;
        for (Map.Entry<DateTime, HashMap<Integer, double[]>> dischargeRecord : dischargeSet) {
            DateTime dateTime = dischargeRecord.getKey();
            HashMap<Integer, double[]> values = dischargeRecord.getValue();
            if (first == null) {
                first = dateTime;
                rainData[index][0] = 1.0;
                Set<Integer> tmp = values.keySet();
                int i = 0;
                for (Integer f : tmp) {
                    rainData[index][i + 1] = values.get(f)[0];
                    ++i;
                }
            } else if (second == null) {
                second = dateTime;
                dt = Math.abs(second.getMinuteOfDay() - first.getMinuteOfDay());
                rainData[index][0] = rainData[index - 1][0] + (double)dt;
                Set<Integer> tmp = values.keySet();
                int i = 0;
                for (Integer f : tmp) {
                    rainData[index][i + 1] = values.get(f)[0];
                    ++i;
                }
            } else {
                rainData[index][0] = rainData[index - 1][0] + (double)dt;
                int i = 0;
                Set<Integer> tmp = values.keySet();
                for (Integer f : tmp) {
                    rainData[index][i + 1] = values.get(f)[0];
                    ++i;
                }
            }
            ++index;
        }
        return rainData;
    }
}

