/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.util.Arrays;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectormerger.OmsVectorMerger;

@Description(value="Module for merging vecotrs into one single.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Feature, Vector, Merge")
@Label(value="Vector Processing")
@Name(value="_vmerge")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class VectorMerger
extends HMModel {
    @Description(value="The first vector to be merged.")
    @UI(value="infile_vector")
    @In
    public String inVector1;
    @Description(value="The second vector to be merged.")
    @UI(value="infile_vector")
    @In
    public String inVector2;
    @Description(value="The output vector.")
    @UI(value="outfile")
    @In
    public String outVector;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inVector1, this.inVector2});
        OmsVectorMerger vectormerger = new OmsVectorMerger();
        vectormerger.inVectors = Arrays.asList(this.getVector(this.inVector1), this.getVector(this.inVector2));
        vectormerger.pm = this.pm;
        vectormerger.doProcess = this.doProcess;
        vectormerger.doReset = this.doReset;
        vectormerger.process();
        this.dumpVector(vectormerger.outVector, this.outVector);
    }
}

