/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectorreshaper.OmsVectorReshaper;

@Description(value="Module to reshape a vector.")
@Author(name="Andrea Antonello, Jody Garnett", contact="http://www.hydrologis.com")
@Keywords(value="Reshape, Vector, OmsVectorFilter")
@Label(value="Vector Processing")
@Name(value="_reshape")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class VectorReshaper
extends HMModel {
    @Description(value="The vector to reshape.")
    @UI(value="infile_vector")
    @In
    public String inVector;
    @Description(value="The ECQL reshape function.")
    @UI(value="multiline5")
    @In
    public String pCql = null;
    @Description(value="The list of fields to remove, comma separated.")
    @In
    public String pRemove = null;
    @Description(value="The new reshaped vector.")
    @UI(value="outfile")
    @In
    public String outVector;

    @Execute
    public void process() throws Exception {
        OmsVectorReshaper vectorreshaper = new OmsVectorReshaper();
        vectorreshaper.inVector = this.getVector(this.inVector);
        vectorreshaper.pCql = this.pCql;
        vectorreshaper.pRemove = this.pRemove;
        vectorreshaper.pm = this.pm;
        vectorreshaper.doProcess = this.doProcess;
        vectorreshaper.doReset = this.doReset;
        vectorreshaper.process();
        this.dumpVector(vectorreshaper.outVector, this.outVector);
    }
}

