/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.windowsampler.OmsWindowSampler;

@Description(value="Module to do coverage downsampling on defined windows.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Coverage, Raster, Downsampling, Interpolation")
@Label(value="Raster Processing")
@Name(value="_winsampler")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class WindowSampler
extends HMModel {
    @Description(value="The input coverage.")
    @UI(value="infile_raster")
    @In
    public String inGeodata;
    @Description(value="The mode to use: average (0 = default), sum (1), max (2), min (3).")
    @In
    public int pMode = 0;
    @Description(value="The windows rows to use (default is 3).")
    @In
    public int pRows = 3;
    @Description(value="The window cols to use (default is 3).")
    @In
    public int pCols = 3;
    @Description(value="The cols to move the window forward (default is = pCols).")
    @In
    public Integer pXstep;
    @Description(value="The rows to move the window forward (default is = pRows).")
    @In
    public Integer pYstep;
    @Description(value="The output coverage.")
    @UI(value="outfile")
    @In
    public String outGeodata;

    @Execute
    public void process() throws Exception {
        OmsWindowSampler windowsampler = new OmsWindowSampler();
        windowsampler.inGeodata = this.getRaster(this.inGeodata);
        windowsampler.pMode = this.pMode;
        windowsampler.pRows = this.pRows;
        windowsampler.pCols = this.pCols;
        windowsampler.pXstep = this.pXstep;
        windowsampler.pYstep = this.pYstep;
        windowsampler.pm = this.pm;
        windowsampler.doProcess = this.doProcess;
        windowsampler.doReset = this.doReset;
        windowsampler.process();
        this.dumpRaster(windowsampler.outGeodata, this.outGeodata);
    }
}

