/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.logging.Logger;
import org.hotrod.config.DisplayMode;
import org.hotrod.exceptions.ControlledException;
import org.hotrod.exceptions.InvalidConfigurationFileException;
import org.hotrod.exceptions.UncontrolledException;
import org.hotrod.generator.Feedback;
import org.hotrod.generator.Generator;
import org.hotrod.generator.HotRodContext;
import org.hotrod.utils.SUtil;
import org.nocrala.tools.database.tartarus.utils.XUtil;

public abstract class AbstractExportColumnsOperation {
    private static final Logger log = Logger.getLogger(AbstractExportColumnsOperation.class.getName());
    protected File baseDir;
    protected String configfilename = null;
    protected String localproperties = null;
    protected String jdbcdriverclass = null;
    protected String jdbcurl = null;
    protected String jdbcusername = null;
    protected String jdbcpassword = null;
    protected String jdbccatalog = null;
    protected String jdbcschema = null;
    protected String facets = null;
    protected String display = null;
    protected String exportfilename = null;
    protected File configFile;
    protected DisplayMode displayMode;
    protected File exportFile;
    private LinkedHashSet<String> facetNames = null;

    protected AbstractExportColumnsOperation(File baseDir, String configfilename, String localproperties, String jdbcdriverclass, String jdbcurl, String jdbcusername, String jdbcpassword, String jdbccatalog, String jdbcschema, String facets, String display, String exportfilename) {
        log.fine("exportfilename=" + exportfilename);
        this.baseDir = baseDir;
        this.configfilename = configfilename;
        this.localproperties = localproperties;
        this.jdbcdriverclass = jdbcdriverclass;
        this.jdbcurl = jdbcurl;
        this.jdbcusername = jdbcusername;
        this.jdbcpassword = jdbcpassword;
        this.jdbccatalog = jdbccatalog;
        this.jdbcschema = jdbcschema;
        this.facets = facets;
        this.display = display;
        this.exportfilename = exportfilename;
    }

    public final void execute(Feedback feedback) throws Exception {
        log.fine("init");
        feedback.info("HotRod version 5.0.3 (build 20250801-192041) - Export Columns TXT");
        this.validateParameters(feedback);
        HotRodContext hc = new HotRodContext(this.configFile, this.jdbcdriverclass, this.jdbcurl, this.jdbcusername, this.jdbcpassword, this.jdbccatalog, this.jdbcschema, this.baseDir, this.facetNames, feedback);
        try {
            Generator g = hc.getConfig().getGenerators().getSelectedGeneratorTag().instantiateGenerator(hc, null, this.displayMode, false, feedback);
            log.fine("Generator instantiated.");
            g.prepareGeneration();
            this.exportColumns(g);
            feedback.info("Column export saved to: " + this.exportFile);
        }
        catch (ControlledException e) {
            if (e.getLocation() == null) {
                throw new Exception("HotRod could not generate the persistence code:\n" + e.getMessage());
            }
            throw new Exception("HotRod could not generate the persistence code. Invalid configuration in " + e.getLocation().render() + ":\n" + e.getMessage());
        }
        catch (UncontrolledException e) {
            feedback.error("Technical error found: " + XUtil.abridge((Throwable)e));
            throw new Exception("HotRod could not generate the persistence code.");
        }
        catch (InvalidConfigurationFileException e) {
            throw new Exception("HotRod could not generate the persistence code. Invalid configuration in " + e.getTag().getSourceLocation().render() + ":\n" + e.getMessage());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Exception("HotRod could not generate the persistence code.");
        }
    }

    protected abstract void exportColumns(Generator var1) throws IOException;

    private final void validateParameters(Feedback feedback) throws Exception {
        if (!SUtil.isEmpty((String)this.localproperties)) {
            feedback.info("Loading local properties from: " + this.localproperties);
            File p = new File(this.baseDir, this.localproperties);
            if (!p.exists()) {
                throw new Exception("HotRod parameter: localproperties file does not exist: " + this.localproperties);
            }
            if (!p.isFile()) {
                throw new Exception("HotRod parameter: localproperties file exists but it's not a regular file: " + this.localproperties);
            }
            BufferedReader r = null;
            Properties props = null;
            try {
                props = new Properties();
                r = new BufferedReader(new FileReader(p));
                props.load(r);
            }
            catch (FileNotFoundException e) {
                throw new Exception("HotRod parameter: localproperties file does not exist: " + this.localproperties);
            }
            catch (IOException e) {
                throw new Exception("HotRod parameter: localproperties: cannot read file: " + e.getMessage() + ": " + this.localproperties);
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.configfilename = props.getProperty("configfile", this.configfilename);
            this.jdbcdriverclass = props.getProperty("jdbcdriverclass", this.jdbcdriverclass);
            this.jdbcurl = props.getProperty("jdbcurl");
            this.jdbcusername = props.getProperty("jdbcusername");
            this.jdbcpassword = props.getProperty("jdbcpassword");
            this.jdbccatalog = props.getProperty("jdbccatalog");
            this.jdbcschema = props.getProperty("jdbcschema");
            this.facets = props.getProperty("facets");
            this.display = props.getProperty("display");
            this.exportfilename = props.getProperty("exportfile", this.exportfilename);
        }
        if (this.configfilename == null) {
            this.configFile = null;
        } else {
            if (SUtil.isEmpty((String)this.configfilename)) {
                throw new Exception("HotRod parameter: configfile attribute cannot be empty.");
            }
            this.configFile = new File(this.baseDir, this.configfilename);
            if (!this.configFile.exists()) {
                throw new Exception("HotRod parameter: configfile does not exist: " + this.configfilename);
            }
        }
        if (this.jdbcdriverclass == null) {
            throw new Exception("HotRod parameter: jdbcdriverclass attribute must be specified.");
        }
        if (SUtil.isEmpty((String)this.jdbcdriverclass)) {
            throw new Exception("HotRod parameter: jdbcdriverclass attribute cannot be empty.");
        }
        if (this.jdbcurl == null) {
            throw new Exception("HotRod parameter: jdbcurl attribute must be specified.");
        }
        if (SUtil.isEmpty((String)this.jdbcurl)) {
            throw new Exception("HotRod parameter: jdbcurl attribute cannot be empty.");
        }
        if (this.jdbcusername == null) {
            throw new Exception("HotRod parameter: jdbcusername attribute must be specified.");
        }
        if (SUtil.isEmpty((String)this.jdbcusername)) {
            throw new Exception("HotRod parameter: jdbcusername attribute cannot be empty.");
        }
        if (this.jdbcpassword == null) {
            throw new Exception("HotRod parameter: jdbcpassword attribute must be specified, even if empty.");
        }
        if (SUtil.isEmpty((String)this.jdbccatalog)) {
            this.jdbccatalog = null;
        }
        if (SUtil.isEmpty((String)this.jdbcschema)) {
            this.jdbcschema = null;
        }
        this.facetNames = new LinkedHashSet();
        if (!SUtil.isEmpty((String)this.facets)) {
            for (String facetName : this.facets.split(",")) {
                if (SUtil.isEmpty((String)facetName)) continue;
                this.facetNames.add(facetName.trim());
            }
        }
        if (SUtil.isEmpty((String)this.display)) {
            this.displayMode = DisplayMode.LIST;
        } else {
            this.displayMode = DisplayMode.parse((String)this.display);
            if (this.displayMode == null) {
                throw new Exception("HotRod parameter: If specified, the attribute display must have one of the following values: summary, list");
            }
        }
        if (this.exportfilename == null) {
            throw new Exception("HotRod parameter: exportfilename attribute must be specified.");
        }
        if (SUtil.isEmpty((String)this.exportfilename)) {
            throw new Exception("HotRod parameter: exportfilename attribute cannot be empty.");
        }
        this.exportFile = new File(this.baseDir, this.exportfilename);
    }
}

