/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.plugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashSet;
import java.util.logging.Logger;
import org.hotrod.generator.Generator;
import org.hotrod.plugin.AbstractExportColumnsOperation;
import org.nocrala.tools.texttablefmt.BorderStyle;
import org.nocrala.tools.texttablefmt.CellStyle;
import org.nocrala.tools.texttablefmt.ShownBorders;
import org.nocrala.tools.texttablefmt.Table;

public class ExportColumnsToTXTOperation
extends AbstractExportColumnsOperation {
    private static final Logger log = Logger.getLogger(ExportColumnsToTXTOperation.class.getName());
    private static final int PAGE_SIZE = 40;

    public ExportColumnsToTXTOperation(File baseDir, String configfilename, String localproperties, String jdbcdriverclass, String jdbcurl, String jdbcusername, String jdbcpassword, String jdbccatalog, String jdbcschema, String facets, String display, String exportfilename) {
        super(baseDir, configfilename, localproperties, jdbcdriverclass, jdbcurl, jdbcusername, jdbcpassword, jdbccatalog, jdbcschema, facets, display, exportfilename);
        log.fine("init");
    }

    @Override
    protected void exportColumns(Generator g) throws IOException {
        LinkedHashSet nativeNames = new LinkedHashSet();
        g.getConfig().getTypeSolverTag().getRetrievedColumns().stream().forEach(c -> {
            if (c.getNative() != null) {
                c.getNative().keySet().stream().forEach(n -> nativeNames.add(n));
            }
        });
        int columns = 15 + nativeNames.size();
        Table t = new Table(columns, BorderStyle.DESIGN_FORMAL_WIDE, ShownBorders.HEADER_AND_COLUMNS);
        t.setColumnWidth(6, 1, 30);
        CellStyle right = new CellStyle(CellStyle.HorizontalAlign.RIGHT);
        CellStyle limited = new CellStyle(CellStyle.HorizontalAlign.LEFT, CellStyle.AbbreviationStyle.DOTS);
        t.addCell("catalog");
        t.addCell("schema");
        t.addCell("objectName");
        t.addCell("ordinal", right);
        t.addCell("name");
        t.addCell("typeName");
        t.addCell("dataType");
        t.addCell("size", right);
        t.addCell("scale", right);
        t.addCell("default", limited);
        t.addCell("autogeneration");
        t.addCell("belongsToPK");
        t.addCell("isVersionControlColumn");
        t.addCell("nature");
        t.addCell("nullable");
        nativeNames.forEach(n -> t.addCell("native." + n));
        g.getConfig().getTypeSolverTag().getRetrievedColumns().stream().forEach(c -> {
            t.addCell(c.getCatalog());
            t.addCell(c.getSchema());
            t.addCell(c.getObjectName());
            t.addCell(c.getOrdinal() == null ? "" : "" + c.getOrdinal(), right);
            t.addCell(c.getName());
            t.addCell(c.getTypeName());
            t.addCell(c.getDataType() == null ? "" : "" + c.getDataType());
            t.addCell(c.getSize() == null ? "" : "" + c.getSize(), right);
            t.addCell(c.getScale() == null ? "" : "" + c.getScale(), right);
            t.addCell(c.getDefault() == null ? "" : "" + c.getDefault(), limited);
            t.addCell(c.getAutogeneration() == null ? "" : "" + c.getAutogeneration());
            t.addCell(c.getBelongsToPK() == null ? "" : "" + c.getBelongsToPK());
            t.addCell(c.getIsOLTimestampColumn() != false || c.getIsOLVersionNumberColumn() != false ? "true" : "");
            t.addCell(c.getNature() == null ? "" : "" + c.getNature());
            t.addCell(c.getNullable() == null ? "" : "" + c.getNullable());
            nativeNames.stream().map(n -> c.getNative() == null ? null : c.getNative().get(n)).map(v -> v == null ? "" : v.toString()).forEach(x -> t.addCell(x));
        });
        DateTimeFormatter df = DateTimeFormatter.ofPattern("d MMM yyyy 'at' HH:mm:ss Z");
        OffsetDateTime now = OffsetDateTime.now();
        try (BufferedWriter w = new BufferedWriter(new FileWriter(this.exportFile));){
            String[] content = t.renderAsStringArray();
            w.write("HotRod Column Export\n");
            w.write("--------------------\n");
            w.write("\n");
            w.write("  From live database at : " + this.jdbcurl + "\n");
            w.write("  Configuration file    : " + this.configFile + "\n");
            w.write("  Catalog               : " + (this.jdbccatalog == null ? "" : this.jdbccatalog) + "\n");
            w.write("  Schema                : " + (this.jdbcschema == null ? "" : this.jdbcschema) + "\n");
            w.write("  Exported              : " + now.format(df) + "\n");
            w.write("  Generated by          : HotRod version 5.0.3 (build 20250801-192041)\n");
            int absLine = 2;
            int line = 40;
            for (int l = absLine; l < content.length; ++l) {
                if (line >= 40) {
                    w.write("\n");
                    w.write(content[0] + "\n");
                    w.write(content[1] + "\n");
                    line = 0;
                }
                w.write(content[l] + "\n");
                ++line;
            }
            w.write("\n");
        }
    }
}

