/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashSet;
import java.util.logging.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.hotrod.generator.Generator;
import org.hotrod.plugin.AbstractExportColumnsOperation;

public class ExportColumnsToXLSXOperation
extends AbstractExportColumnsOperation {
    private static final Logger log = Logger.getLogger(ExportColumnsToXLSXOperation.class.getName());
    private int line;
    private int col;

    public ExportColumnsToXLSXOperation(File baseDir, String configfilename, String localproperties, String jdbcdriverclass, String jdbcurl, String jdbcusername, String jdbcpassword, String jdbccatalog, String jdbcschema, String facets, String display, String exportfilename) {
        super(baseDir, configfilename, localproperties, jdbcdriverclass, jdbcurl, jdbcusername, jdbcpassword, jdbccatalog, jdbcschema, facets, display, exportfilename);
        log.fine("init");
    }

    @Override
    protected void exportColumns(Generator g) throws IOException {
        LinkedHashSet nativeNames = new LinkedHashSet();
        g.getConfig().getTypeSolverTag().getRetrievedColumns().stream().forEach(c -> {
            if (c.getNative() != null) {
                c.getNative().keySet().stream().forEach(n -> nativeNames.add(n));
            }
        });
        DateTimeFormatter df = DateTimeFormatter.ofPattern("d MMM yyyy 'at' HH:mm:ss Z");
        OffsetDateTime now = OffsetDateTime.now();
        try (XSSFWorkbook workbook = new XSSFWorkbook();
             FileOutputStream os = new FileOutputStream(this.exportFile);){
            Sheet sheet = workbook.createSheet("Database Columns");
            this.line = 0;
            CellStyle nameStyle = workbook.createCellStyle();
            XSSFFont nfont = workbook.createFont();
            nfont.setFontName("Arial");
            nfont.setFontHeightInPoints((short)16);
            nfont.setBold(true);
            nameStyle.setFont((Font)nfont);
            Row title = sheet.createRow(this.line++);
            this.col = 0;
            this.addCell(title, nameStyle, "HotRod Column Export");
            Row details = sheet.createRow(this.line++);
            this.col = 0;
            this.addCell(details, null, "");
            details = sheet.createRow(this.line++);
            this.col = 0;
            this.addCell(details, null, "  From live database at: " + this.jdbcurl);
            details = sheet.createRow(this.line++);
            this.col = 0;
            this.addCell(details, null, "  Configuration file: " + this.configFile);
            details = sheet.createRow(this.line++);
            this.col = 0;
            this.addCell(details, null, "  Catalog: " + (this.jdbccatalog == null ? "" : this.jdbccatalog));
            details = sheet.createRow(this.line++);
            this.col = 0;
            this.addCell(details, null, "  Schema: " + (this.jdbcschema == null ? "" : this.jdbcschema));
            details = sheet.createRow(this.line++);
            this.col = 0;
            this.addCell(details, null, "  Exported: " + now.format(df));
            this.col = 0;
            this.addCell(details, null, "  Generated by: HotRod version 5.0.3 (build 20250801-192041)");
            details = sheet.createRow(this.line++);
            this.col = 0;
            this.addCell(details, null, "");
            Row header = sheet.createRow(this.line++);
            CellStyle headerStyle = workbook.createCellStyle();
            XSSFFont font = workbook.createFont();
            font.setFontName("Arial");
            font.setFontHeightInPoints((short)10);
            font.setBold(true);
            headerStyle.setFont((Font)font);
            this.col = 0;
            this.addCell(header, headerStyle, "catalog");
            this.addCell(header, headerStyle, "schema");
            this.addCell(header, headerStyle, "objectName");
            this.addCell(header, headerStyle, "ordinal");
            this.addCell(header, headerStyle, "name");
            this.addCell(header, headerStyle, "typeName");
            this.addCell(header, headerStyle, "dataType");
            this.addCell(header, headerStyle, "size");
            this.addCell(header, headerStyle, "scale");
            this.addCell(header, headerStyle, "default");
            this.addCell(header, headerStyle, "autogeneration");
            this.addCell(header, headerStyle, "belongsToPK");
            this.addCell(header, headerStyle, "isVersionControlColumn");
            this.addCell(header, headerStyle, "nature");
            this.addCell(header, headerStyle, "nullable");
            nativeNames.forEach(n -> this.addCell(header, headerStyle, "native." + n));
            CellStyle style = workbook.createCellStyle();
            g.getConfig().getTypeSolverTag().getRetrievedColumns().stream().forEach(c -> {
                Row body = sheet.createRow(this.line++);
                this.col = 0;
                this.addCell(body, style, c.getCatalog());
                this.addCell(body, style, c.getSchema());
                this.addCell(body, style, c.getObjectName());
                this.addCell(body, style, c.getOrdinal() == null ? "" : "" + c.getOrdinal());
                this.addCell(body, style, c.getName());
                this.addCell(body, style, c.getTypeName());
                this.addCell(body, style, c.getDataType() == null ? "" : "" + c.getDataType());
                this.addCell(body, style, c.getSize() == null ? "" : "" + c.getSize());
                this.addCell(body, style, c.getScale() == null ? "" : "" + c.getScale());
                this.addCell(body, style, c.getDefault() == null ? "" : "" + c.getDefault());
                this.addCell(body, style, c.getAutogeneration() == null ? "" : "" + c.getAutogeneration());
                this.addCell(body, style, c.getBelongsToPK() == null ? "" : "" + c.getBelongsToPK());
                this.addCell(body, style, c.getIsOLTimestampColumn() != false || c.getIsOLVersionNumberColumn() != false ? "true" : "");
                this.addCell(body, style, c.getNature() == null ? "" : "" + c.getNature());
                this.addCell(body, style, c.getNullable() == null ? "" : "" + c.getNullable());
                nativeNames.stream().map(n -> c.getNative() == null ? null : c.getNative().get(n)).map(v -> v == null ? "" : v.toString()).forEach(x -> this.addCell(body, style, (String)x));
            });
            try {
                sheet.setColumnWidth(0, 2500);
                for (int i = 1; i < 15 + nativeNames.size(); ++i) {
                    sheet.autoSizeColumn(i);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            workbook.write((OutputStream)os);
        }
    }

    private void addCell(Row r, CellStyle style, String content) {
        Cell c = r.createCell(this.col++);
        c.setCellValue(content);
        if (style != null) {
            c.setCellStyle(style);
        }
    }
}

