/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.logging.Logger;
import org.hotrod.api.HotRodServices;
import org.hotrod.config.DisplayMode;
import org.hotrod.generator.Feedback;
import org.hotrod.utils.SUtil;

public class GenOperation {
    private static final Logger log = Logger.getLogger(GenOperation.class.getName());
    private File baseDir;
    private String configfilename = null;
    private String localproperties = null;
    private String jdbcdriverclass = null;
    private String jdbcurl = null;
    private String jdbcusername = null;
    private String jdbcpassword = null;
    private String jdbccatalog = null;
    private String jdbcschema = null;
    private String facets = null;
    private String display = null;
    private File configFile;
    private DisplayMode displayMode;
    private LinkedHashSet<String> facetNames = null;

    public GenOperation(File baseDir, String configfilename, String localproperties, String jdbcdriverclass, String jdbcurl, String jdbcusername, String jdbcpassword, String jdbccatalog, String jdbcschema, String facets, String display) throws Exception {
        this.baseDir = baseDir;
        this.configfilename = configfilename;
        this.localproperties = localproperties;
        this.jdbcdriverclass = jdbcdriverclass;
        this.jdbcurl = jdbcurl;
        this.jdbcusername = jdbcusername;
        this.jdbcpassword = jdbcpassword;
        this.jdbccatalog = jdbccatalog;
        this.jdbcschema = jdbcschema;
        this.facets = facets;
        this.display = display;
        this.validateParameters();
    }

    public void execute(Feedback feedback) throws Exception {
        HotRodServices hs = new HotRodServices(this.baseDir, this.jdbcdriverclass, this.jdbcurl, this.jdbcusername, this.jdbcpassword, this.jdbccatalog, this.jdbcschema, this.configFile, this.displayMode, this.facetNames);
        hs.generate(feedback);
    }

    private void validateParameters() throws Exception {
        if (!SUtil.isEmpty((String)this.localproperties)) {
            File p = new File(this.baseDir, this.localproperties);
            if (!p.exists()) {
                throw new Exception("HotRod parameter: localproperties file does not exist: " + this.localproperties);
            }
            if (!p.isFile()) {
                throw new Exception("HotRod parameter: localproperties file exists but it's not a regular file: " + this.localproperties);
            }
            BufferedReader r = null;
            Properties props = null;
            try {
                props = new Properties();
                r = new BufferedReader(new FileReader(p));
                props.load(r);
            }
            catch (FileNotFoundException e) {
                throw new Exception("HotRod parameter: localproperties file does not exist: " + this.localproperties);
            }
            catch (IOException e) {
                throw new Exception("HotRod parameter: localproperties: cannot read file: " + e.getMessage() + ": " + this.localproperties);
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.configfilename = props.getProperty("configfile", this.configfilename);
            this.jdbcdriverclass = props.getProperty("jdbcdriverclass", this.jdbcdriverclass);
            this.jdbcurl = props.getProperty("jdbcurl");
            this.jdbcusername = props.getProperty("jdbcusername");
            this.jdbcpassword = props.getProperty("jdbcpassword");
            this.jdbccatalog = props.getProperty("jdbccatalog");
            this.jdbcschema = props.getProperty("jdbcschema");
            this.facets = props.getProperty("facets");
            this.display = props.getProperty("display");
        }
        if (this.configfilename != null) {
            this.configFile = new File(this.baseDir, this.configfilename);
            if (!this.configFile.exists()) {
                throw new Exception("HotRod parameter: configfile does not exist: " + this.configfilename);
            }
        }
        if (this.jdbcdriverclass == null) {
            throw new Exception("HotRod parameter: jdbcdriverclass attribute must be specified.");
        }
        if (SUtil.isEmpty((String)this.jdbcdriverclass)) {
            throw new Exception("HotRod parameter: jdbcdriverclass attribute cannot be empty.");
        }
        if (this.jdbcurl == null) {
            throw new Exception("HotRod parameter: jdbcurl attribute must be specified.");
        }
        if (SUtil.isEmpty((String)this.jdbcurl)) {
            throw new Exception("HotRod parameter: jdbcurl attribute cannot be empty.");
        }
        if (this.jdbcusername == null) {
            throw new Exception("HotRod parameter: jdbcusername attribute must be specified.");
        }
        if (SUtil.isEmpty((String)this.jdbcusername)) {
            throw new Exception("HotRod parameter: jdbcusername attribute cannot be empty.");
        }
        if (this.jdbcpassword == null) {
            throw new Exception("HotRod parameter: jdbcpassword attribute must be specified, even if empty.");
        }
        if (SUtil.isEmpty((String)this.jdbccatalog)) {
            this.jdbccatalog = null;
        }
        if (SUtil.isEmpty((String)this.jdbcschema)) {
            this.jdbcschema = null;
        }
        this.facetNames = new LinkedHashSet();
        if (!SUtil.isEmpty((String)this.facets)) {
            for (String facetName : this.facets.split(",")) {
                if (SUtil.isEmpty((String)facetName)) continue;
                this.facetNames.add(facetName.trim());
            }
        }
        if (SUtil.isEmpty((String)this.display)) {
            this.displayMode = DisplayMode.LIST;
        } else {
            this.displayMode = DisplayMode.parse((String)this.display);
            if (this.displayMode == null) {
                throw new Exception("HotRod parameter: If specified, the attribute display must have one of the following values: summary, list");
            }
        }
    }
}

