/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.dynamicsql;

import java.util.HashMap;
import java.util.Map;

public class JDBCTypes {
    private static Map<Integer, JDBCType> mapByCode = new HashMap<Integer, JDBCType>();
    private static Map<String, JDBCType> mapByTypeName = new HashMap<String, JDBCType>();
    private static Map<String, JDBCType> mapByShortTypeName = new HashMap<String, JDBCType>();

    private JDBCTypes() {
    }

    public static Integer nameToCode(String jdbcTypeName) {
        JDBCType t = mapByTypeName.get(jdbcTypeName);
        if (t != null) {
            return t.getCode();
        }
        t = mapByShortTypeName.get(jdbcTypeName);
        return t == null ? null : Integer.valueOf(t.getCode());
    }

    public static JDBCType nameToType(String jdbcTypeName) {
        JDBCType t = mapByTypeName.get(jdbcTypeName);
        if (t != null) {
            return t;
        }
        return mapByShortTypeName.get(jdbcTypeName);
    }

    public static String codeToName(int code) {
        JDBCType t = mapByCode.get(code);
        return t == null ? null : t.getTypeName();
    }

    public static JDBCType codeToType(int code) {
        return mapByCode.get(code);
    }

    public static String codeToShortName(int code) {
        JDBCType t = mapByCode.get(code);
        return t == null ? null : t.getShortTypeName();
    }

    static {
        for (JDBCType t : JDBCType.values()) {
            mapByCode.put(t.getCode(), t);
            mapByTypeName.put(t.getTypeName(), t);
            mapByShortTypeName.put(t.getShortTypeName(), t);
        }
    }

    public static enum JDBCType {
        ARRAY("ARRAY", 2003),
        BIGINT("BIGINT", -5),
        BINARY("BINARY", -2),
        BIT("BIT", -7),
        BLOB("BLOB", 2004),
        BOOLEAN("BOOLEAN", 16),
        CHAR("CHAR", 1),
        CLOB("CLOB", 2005),
        DATALINK("DATALINK", 70),
        DATE("DATE", 91),
        DECIMAL("DECIMAL", 3),
        DISTINCT("DISTINCT", 2001),
        DOUBLE("DOUBLE", 8),
        FLOAT("FLOAT", 6),
        INTEGER("INTEGER", 4),
        JAVA_OBJECT("JAVA_OBJECT", 2000),
        LONGNVARCHAR("LONGNVARCHAR", -16),
        LONGVARBINARY("LONGVARBINARY", -4),
        LONGVARCHAR("LONGVARCHAR", -1),
        NCHAR("NCHAR", -15),
        NCLOB("NCLOB", 2011),
        NULL("NULL", 0),
        NUMERIC("NUMERIC", 2),
        NVARCHAR("NVARCHAR", -9),
        OTHER("OTHER", 1111),
        REAL("REAL", 7),
        REF("REF", 2006),
        REF_CURSOR("REF_CURSOR", 2012),
        ROWID("ROWID", -8),
        SMALLINT("SMALLINT", 5),
        SQLXML("SQLXML", 2009),
        STRUCT("STRUCT", 2002),
        TIME("TIME", 92),
        TIME_WITH_TIMEZONE("TIME_WITH_TIMEZONE", 2013),
        TIMESTAMP("TIMESTAMP", 93),
        TIMESTAMP_WITH_TIMEZONE("TIMESTAMP_WITH_TIMEZONE", 2014),
        TINYINT("TINYINT", -6),
        VARBINARY("VARBINARY", -3),
        VARCHAR("VARCHAR", 12);

        private int code;
        private String shortTypeName;
        private String typeName;

        private JDBCType(String shortTypeName, int code) {
            this.code = code;
            this.shortTypeName = shortTypeName;
            this.typeName = "java.sql.Types." + shortTypeName;
        }

        public int getCode() {
            return this.code;
        }

        public String getShortTypeName() {
            return this.shortTypeName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String toString() {
            return "code:" + this.code + ", shortTypeName:" + this.shortTypeName + " typeName:" + this.typeName;
        }
    }
}

