/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.dynamicsql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.hotrod.dynamicsql.Cursor;
import org.hotrod.dynamicsql.DynamicCursor;
import org.hotrod.dynamicsql.PreparedQuery;
import org.hotrod.dynamicsql.RowReader;
import org.hotrod.dynamicsql.SimpleStaticSegmentConsumer;
import org.hotrod.dynamicsql.parameters.ParameterOccurrence;

public class PreparedSelectQuery<R>
extends PreparedQuery {
    private static final Logger log = Logger.getLogger(PreparedSelectQuery.class.getName());
    private RowReader<R> rr;

    public PreparedSelectQuery(SimpleStaticSegmentConsumer sc, RowReader<R> rr) {
        super(sc.getSQL(), sc.getParameters());
        this.rr = rr;
    }

    public List<R> execute(Connection conn) throws SQLException {
        try (PreparedStatement ps = this.prepareStatement(conn);){
            ArrayList<R> arrayList;
            block13: {
                this.applyParameters(ps, conn);
                ResultSet rs = ps.executeQuery();
                try {
                    this.rr.discoverColumns(rs);
                    ArrayList<R> rows = new ArrayList<R>();
                    while (rs.next()) {
                        R r = this.rr.readRowFrom(rs, conn);
                        rows.add(r);
                    }
                    arrayList = rows;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }

    public R executeOne(Connection conn) throws SQLException {
        try (PreparedStatement ps = this.prepareStatement(conn);){
            R r;
            block17: {
                ResultSet rs;
                block15: {
                    R r2;
                    block16: {
                        this.applyParameters(ps, conn);
                        rs = ps.executeQuery();
                        try {
                            this.rr.discoverColumns(rs);
                            if (!rs.next()) break block15;
                            R r3 = this.rr.readRowFrom(rs, conn);
                            if (rs.next()) {
                                throw new RuntimeException(".executeOne() expects a single row at the most, but this SELECT query produced more than one row");
                            }
                            r2 = r3;
                            if (rs == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return r2;
                }
                r = null;
                if (rs == null) break block17;
                rs.close();
            }
            return r;
        }
    }

    PreparedStatement prepareStatement(Connection conn) throws SQLException {
        return conn.prepareStatement(this.sql);
    }

    void applyParameters(PreparedStatement ps, Connection conn) throws SQLException {
        int ordinal = 1;
        for (ParameterOccurrence p : this.parameters) {
            p.applyTo(ps, ordinal++, conn);
        }
    }

    public Cursor<R> executeCursor(Connection conn) throws SQLException {
        return new DynamicCursor<R>(conn, this, this.rr, null);
    }

    public Cursor<R> executeCursor(Connection conn, Integer fetchSize) throws SQLException {
        return new DynamicCursor<R>(conn, this, this.rr, fetchSize);
    }
}

