/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.dynamicsql.jexl;

import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.jexl3.JexlContext;
import org.hotrod.dynamicsql.DynamicExpressionException;
import org.hotrod.dynamicsql.Parameters;

public class JEXLParameterContext
extends Parameters
implements JexlContext {
    private static final Logger log = Logger.getLogger(JEXLParameterContext.class.getName());
    private static final Pattern VALID_SIMPLE_NAME = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]*");

    public Object get(String name) {
        return this.paramValues.get(name);
    }

    public void set(String name, Object value) {
        throw new UnsupportedOperationException("The parameter context cannot be modified");
    }

    public boolean has(String name) {
        return this.paramValues.containsKey(name);
    }

    @Override
    public boolean hasParameter(String name) {
        return this.has(name);
    }

    @Override
    public Object getParameterValue(String name) {
        return this.get(name);
    }

    @Override
    public void bind(String name, Object value) throws DynamicExpressionException {
        if (!VALID_SIMPLE_NAME.matcher(name).matches()) {
            throw new DynamicExpressionException("Invalid variable name '" + name + "': must a letter followed by alphanumeric characters or underscores.");
        }
        this.paramValues.put(name, value);
    }

    @Override
    public Object unbind(String name) {
        return this.paramValues.remove(name);
    }
}

