/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.dynamicsql.assembler;

import org.hotrod.converter.TypeConverter;
import org.hotrod.dynamicsql.DynamicExpressionFactory;
import org.hotrod.dynamicsql.assembler.AbstractSentence;
import org.hotrod.dynamicsql.assembler.Begin;
import org.hotrod.dynamicsql.assembler.Choose;
import org.hotrod.dynamicsql.assembler.DynShield;
import org.hotrod.dynamicsql.assembler.ForEach;
import org.hotrod.dynamicsql.assembler.If;
import org.hotrod.dynamicsql.assembler.Set;
import org.hotrod.dynamicsql.assembler.Trim;
import org.hotrod.dynamicsql.assembler.Where;
import org.hotrod.dynamicsql.segments.BindSegment;
import org.hotrod.dynamicsql.segments.ParameterInjectionSegment;
import org.hotrod.dynamicsql.segments.ParameterNotNullableSegment;
import org.hotrod.dynamicsql.segments.ParameterNotNullableUpdatableSegment;
import org.hotrod.dynamicsql.segments.ParameterNullableSegment;
import org.hotrod.dynamicsql.segments.StaticContentSegment;
import org.hotrod.dynamicsql.segments.VariableSegment;

public abstract class Sentence<M extends Sentence<?, ?>, P>
extends AbstractSentence<M, P> {
    protected Sentence(DynamicExpressionFactory factory, M me, P parent) {
        super(factory, me, parent);
    }

    public M literal(String text) {
        this.segments.add(new StaticContentSegment(text));
        return (M)((Sentence)this.me);
    }

    public M literaln() {
        return this.literal("\n");
    }

    public M literaln(String text) {
        return this.literal(text + "\n");
    }

    public M parameter(String name) {
        this.segments.add(new ParameterNotNullableSegment(this.factory, name, null));
        return (M)((Sentence)this.me);
    }

    public M parameter(String name, TypeConverter<?, ?> converter) {
        this.segments.add(new ParameterNotNullableSegment(this.factory, name, converter));
        return (M)((Sentence)this.me);
    }

    public M parameterUpdatable(String name) {
        this.segments.add(new ParameterNotNullableUpdatableSegment(this.factory, name, null));
        return (M)((Sentence)this.me);
    }

    public M parameterUpdatable(String name, TypeConverter<?, ?> converter) {
        this.segments.add(new ParameterNotNullableUpdatableSegment(this.factory, name, converter));
        return (M)((Sentence)this.me);
    }

    public M parameterNullable(String name, int sqlType) {
        this.segments.add(new ParameterNullableSegment(this.factory, name, sqlType, null));
        return (M)((Sentence)this.me);
    }

    public M parameterNullable(String name, int sqlType, TypeConverter<?, ?> converter) {
        this.segments.add(new ParameterNullableSegment(this.factory, name, sqlType, converter));
        return (M)((Sentence)this.me);
    }

    public M parameterInjection(String name) {
        this.segments.add(new ParameterInjectionSegment(this.factory, name));
        return (M)((Sentence)this.me);
    }

    public M variable(String name) {
        this.segments.add(new VariableSegment(this.factory, name, null));
        return (M)((Sentence)this.me);
    }

    public M variable(String name, TypeConverter<?, ?> converter) {
        this.segments.add(new VariableSegment(this.factory, name, converter));
        return (M)((Sentence)this.me);
    }

    public Begin<M> begin() {
        Begin<Sentence> s = new Begin<Sentence>(this.factory, this);
        return s;
    }

    public If<M> if_(String test) {
        If<Sentence> s = new If<Sentence>(this.factory, this, test);
        return s;
    }

    public Choose<M> choose() {
        Choose<Sentence> s = new Choose<Sentence>(this.factory, this);
        return s;
    }

    public Where<M> where(String separator) {
        Where<Sentence> s = new Where<Sentence>(this.factory, this, separator);
        return s;
    }

    public Set<M> set() {
        Set<Sentence> s = new Set<Sentence>(this.factory, this);
        return s;
    }

    public Trim<M> trim(String header, String separator, String tail) {
        Trim<Sentence> s = new Trim<Sentence>(this.factory, this, header, separator, tail);
        return s;
    }

    public ForEach<M> foreach(String item, String collection, String open, String separator, String close) {
        ForEach<Sentence> s = new ForEach<Sentence>(this.factory, this, item, collection, open, separator, close);
        return s;
    }

    public M bind(String name, String value) {
        BindSegment s = new BindSegment(name, value, this.factory);
        DynShield.addSegment(this, s);
        return (M)((Sentence)this.me);
    }
}

