/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.dynamicsql.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.hotrod.runtime.dynamicsql.DynamicSQLEvaluationException;
import org.hotrod.runtime.dynamicsql.DynamicSQLParameters;
import org.hotrod.runtime.dynamicsql.EvaluationFeedback;
import org.hotrod.runtime.dynamicsql.expressions.DynamicExpression;
import org.hotrod.runtime.util.ListWriter;
import org.hotrod.runtime.util.SUtils;

public class TrimExpression
extends DynamicExpression {
    private String prefix;
    private LinkedHashSet<String> prefixOverrides;
    private String suffix;
    private LinkedHashSet<String> suffixOverrides;
    protected DynamicExpression[] expressions;

    public TrimExpression(String prefix, String prefixOverrides, String suffix, String suffixOverrides, DynamicExpression ... expressions) {
        this.prefix = prefix;
        this.prefixOverrides = new LinkedHashSet();
        if (prefixOverrides != null) {
            this.parseOverrides(prefixOverrides, this.prefixOverrides);
        }
        this.suffix = suffix;
        this.suffixOverrides = new LinkedHashSet();
        if (suffixOverrides != null) {
            this.parseOverrides(suffixOverrides, this.suffixOverrides);
        }
        this.expressions = expressions;
    }

    private void parseOverrides(String overrides, Set<String> set) {
        String[] parts;
        if (overrides != null && (parts = overrides.split("\\|")) != null) {
            for (String chunk : parts) {
                if (chunk == null || chunk.isEmpty()) continue;
                set.add(chunk);
            }
        }
    }

    @Override
    public EvaluationFeedback evaluate(StringBuilder out, DynamicSQLParameters variables) throws DynamicSQLEvaluationException {
        StringBuilder sb = new StringBuilder();
        boolean contentRendered = false;
        for (DynamicExpression expr : this.expressions) {
            EvaluationFeedback feedback = expr.evaluate(sb, variables);
            contentRendered = contentRendered || feedback.wasContentRendered();
        }
        String rendered = sb.toString().trim();
        if (contentRendered) {
            String s;
            String p = this.searchForPrefix(rendered);
            if (p != null) {
                rendered = rendered.substring(p.length());
            }
            if ((s = this.searchForSuffix(rendered)) != null) {
                rendered = rendered.substring(0, rendered.length() - s.length());
            }
            String content = (this.prefix != null ? this.prefix : "") + rendered + (this.suffix != null ? this.suffix : "");
            out.append(content);
        }
        return new EvaluationFeedback(contentRendered);
    }

    private String searchForPrefix(String txt) {
        for (String p : this.prefixOverrides) {
            if (!SUtils.startsWithIgnoreCase(txt, p)) continue;
            return p;
        }
        return null;
    }

    private String searchForSuffix(String txt) {
        for (String p : this.suffixOverrides) {
            if (!SUtils.endsWithIgnoreCase(txt, p)) continue;
            return p;
        }
        return null;
    }

    @Override
    public List<Object> getConstructorParameters() {
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<String> stringParams = new ArrayList<String>();
        stringParams.add(this.prefix);
        stringParams.add(ListWriter.render(this.prefixOverrides, "|"));
        stringParams.add(this.suffix);
        stringParams.add(ListWriter.render(this.suffixOverrides, "|"));
        params.add(stringParams);
        params.addAll(Arrays.asList(this.expressions));
        return params;
    }
}

