/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.json;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hotrod.runtime.json.JSONBoolean;
import org.hotrod.runtime.json.JSONNullValue;
import org.hotrod.runtime.json.JSONNumber;
import org.hotrod.runtime.json.JSONObject;
import org.hotrod.runtime.json.JSONString;
import org.hotrod.runtime.json.JSONValue;

public class JSONArray
implements JSONValue {
    private List<JSONValue> values = new ArrayList<JSONValue>();

    public void addValue(JSONObject o) {
        this.add(o);
    }

    public void addValue(JSONArray a) {
        this.add(a);
    }

    public void addValue(String s) {
        this.add(new JSONString(s));
    }

    public void addValue(Number n) {
        this.add(new JSONNumber(n));
    }

    public void addValue(boolean b) {
        this.add(new JSONBoolean(b));
    }

    public void addNullValue() {
        this.add(new JSONNullValue());
    }

    public void addValue(Date d) {
        this.add(d == null ? new JSONNullValue() : new JSONString(JSONObject.formatTimestamp(d)));
    }

    public void addValue(Object obj) {
        this.add(obj == null ? new JSONNullValue() : new JSONString(obj.toString()));
    }

    private void add(JSONValue v) {
        this.values.add(v != null ? v : new JSONNullValue());
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        boolean first = true;
        for (JSONValue v : this.values) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(v.render());
        }
        sb.append(" ]");
        return sb.toString();
    }
}

