/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.json;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.TimeZone;
import org.hotrod.runtime.json.JSONArray;
import org.hotrod.runtime.json.JSONBoolean;
import org.hotrod.runtime.json.JSONNullValue;
import org.hotrod.runtime.json.JSONNumber;
import org.hotrod.runtime.json.JSONString;
import org.hotrod.runtime.json.JSONValue;

public class JSONObject
implements JSONValue {
    private LinkedHashMap<JSONString, JSONValue> properties = new LinkedHashMap();

    public void addProperty(String name, JSONObject o) {
        this.add(name, o);
    }

    public void addProperty(String name, JSONArray a) {
        this.add(name, a);
    }

    public void addProperty(String name, String s) {
        this.add(name, s != null ? new JSONString(s) : new JSONNullValue());
    }

    public void addProperty(String name, Number n) {
        this.add(name, n != null ? new JSONNumber(n) : new JSONNullValue());
    }

    public void addProperty(String name, boolean b) {
        this.add(name, new JSONBoolean(b));
    }

    public void addNullProperty(String name) {
        this.add(name, new JSONNullValue());
    }

    public void addProperty(String name, Date d) {
        this.add(name, d == null ? new JSONNullValue() : new JSONString(JSONObject.formatTimestamp(d)));
    }

    public void addProperty(String name, Object obj) {
        this.add(name, obj == null ? new JSONNullValue() : new JSONString(obj.toString()));
    }

    private void add(String name, JSONValue v) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot add property with empty name.");
        }
        JSONString key = new JSONString(name);
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Cannot add property '" + name + "' since it already exists.");
        }
        this.properties.put(key, v != null ? v : new JSONNullValue());
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        boolean first = true;
        for (JSONString key : this.properties.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            JSONValue v = this.properties.get(key);
            sb.append(key.render());
            sb.append(": ");
            sb.append(v.render());
        }
        sb.append(" }");
        return sb.toString();
    }

    static String formatTimestamp(Date d) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(tz);
        String formatted = df.format(d);
        return formatted;
    }
}

