/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.hotrod.runtime.livesql.dialects.SQLDialect;
import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.expressions.ResultSetColumn;
import org.hotrod.runtime.livesql.expressions.aggregations.Avg;
import org.hotrod.runtime.livesql.expressions.aggregations.AvgDistinct;
import org.hotrod.runtime.livesql.expressions.aggregations.BooleanMax;
import org.hotrod.runtime.livesql.expressions.aggregations.BooleanMin;
import org.hotrod.runtime.livesql.expressions.aggregations.ByteArrayMax;
import org.hotrod.runtime.livesql.expressions.aggregations.ByteArrayMin;
import org.hotrod.runtime.livesql.expressions.aggregations.Count;
import org.hotrod.runtime.livesql.expressions.aggregations.CountDistinct;
import org.hotrod.runtime.livesql.expressions.aggregations.DateTimeMax;
import org.hotrod.runtime.livesql.expressions.aggregations.DateTimeMin;
import org.hotrod.runtime.livesql.expressions.aggregations.GroupConcat;
import org.hotrod.runtime.livesql.expressions.aggregations.GroupConcatDistinct;
import org.hotrod.runtime.livesql.expressions.aggregations.NumberMax;
import org.hotrod.runtime.livesql.expressions.aggregations.NumberMin;
import org.hotrod.runtime.livesql.expressions.aggregations.ObjectMax;
import org.hotrod.runtime.livesql.expressions.aggregations.ObjectMin;
import org.hotrod.runtime.livesql.expressions.aggregations.StringMax;
import org.hotrod.runtime.livesql.expressions.aggregations.StringMin;
import org.hotrod.runtime.livesql.expressions.aggregations.Sum;
import org.hotrod.runtime.livesql.expressions.aggregations.SumDistinct;
import org.hotrod.runtime.livesql.expressions.analytics.DenseRank;
import org.hotrod.runtime.livesql.expressions.analytics.Lag;
import org.hotrod.runtime.livesql.expressions.analytics.Lead;
import org.hotrod.runtime.livesql.expressions.analytics.NTile;
import org.hotrod.runtime.livesql.expressions.analytics.Rank;
import org.hotrod.runtime.livesql.expressions.analytics.RowNumber;
import org.hotrod.runtime.livesql.expressions.binary.ByteArrayConstant;
import org.hotrod.runtime.livesql.expressions.binary.ByteArrayExpression;
import org.hotrod.runtime.livesql.expressions.binary.ByteArrayValue;
import org.hotrod.runtime.livesql.expressions.caseclause.CaseWhenStage;
import org.hotrod.runtime.livesql.expressions.datetime.CurrentDate;
import org.hotrod.runtime.livesql.expressions.datetime.CurrentDateTime;
import org.hotrod.runtime.livesql.expressions.datetime.CurrentTime;
import org.hotrod.runtime.livesql.expressions.datetime.DateTime;
import org.hotrod.runtime.livesql.expressions.datetime.DateTimeConstant;
import org.hotrod.runtime.livesql.expressions.datetime.DateTimeExpression;
import org.hotrod.runtime.livesql.expressions.datetime.DateTimeValue;
import org.hotrod.runtime.livesql.expressions.general.Tuple;
import org.hotrod.runtime.livesql.expressions.numbers.NumberConstant;
import org.hotrod.runtime.livesql.expressions.numbers.NumberExpression;
import org.hotrod.runtime.livesql.expressions.numbers.NumberValue;
import org.hotrod.runtime.livesql.expressions.object.ObjectConstant;
import org.hotrod.runtime.livesql.expressions.object.ObjectExpression;
import org.hotrod.runtime.livesql.expressions.object.ObjectValue;
import org.hotrod.runtime.livesql.expressions.predicates.BooleanConstant;
import org.hotrod.runtime.livesql.expressions.predicates.BooleanValue;
import org.hotrod.runtime.livesql.expressions.predicates.Exists;
import org.hotrod.runtime.livesql.expressions.predicates.Not;
import org.hotrod.runtime.livesql.expressions.predicates.NotExists;
import org.hotrod.runtime.livesql.expressions.predicates.Predicate;
import org.hotrod.runtime.livesql.expressions.strings.StringConstant;
import org.hotrod.runtime.livesql.expressions.strings.StringExpression;
import org.hotrod.runtime.livesql.expressions.strings.StringValue;
import org.hotrod.runtime.livesql.ordering.OrderingTerm;
import org.hotrod.runtime.livesql.queries.select.ExecutableSelect;
import org.hotrod.runtime.livesql.queries.select.SelectColumnsPhase;

public class LiveSQL {
    private SqlSession sqlSession;
    private SQLDialect sqlDialect;

    public void setSqlSession(SqlSession sqlSession) {
        this.sqlSession = sqlSession;
    }

    public void setSqlDialect(SQLDialect sqlDialect) {
        this.sqlDialect = sqlDialect;
    }

    public SelectColumnsPhase<Map<String, Object>> select() {
        return new SelectColumnsPhase<Map<String, Object>>(this.sqlDialect, this.sqlSession, false, new ResultSetColumn[0]);
    }

    public SelectColumnsPhase<Map<String, Object>> selectDistinct() {
        return new SelectColumnsPhase<Map<String, Object>>(this.sqlDialect, this.sqlSession, true, new ResultSetColumn[0]);
    }

    public SelectColumnsPhase<Map<String, Object>> select(ResultSetColumn ... resultSetColumns) {
        return new SelectColumnsPhase<Map<String, Object>>(this.sqlDialect, this.sqlSession, false, resultSetColumns);
    }

    public SelectColumnsPhase<Map<String, Object>> selectDistinct(ResultSetColumn ... resultSetColumns) {
        return new SelectColumnsPhase<Map<String, Object>>(this.sqlDialect, this.sqlSession, true, resultSetColumns);
    }

    public Tuple tuple(Expression<?> ... expressions) {
        return new Tuple(expressions);
    }

    public Predicate not(Expression<Boolean> a) {
        return new Not(a);
    }

    public <R> Predicate exists(ExecutableSelect<R> subquery) {
        return new Exists(subquery);
    }

    public <R> Predicate notExists(ExecutableSelect<R> subquery) {
        return new NotExists(subquery);
    }

    public Count count() {
        return new Count();
    }

    public CountDistinct countDistinct(Expression<?> expression) {
        return new CountDistinct(expression);
    }

    public SumDistinct sumDistinct(Expression<?> expression) {
        return new SumDistinct(expression);
    }

    public AvgDistinct avgDistinct(Expression<?> expression) {
        return new AvgDistinct(expression);
    }

    public GroupConcatDistinct groupConcatDistinct(Expression<String> expression) {
        return new GroupConcatDistinct(expression, null, null);
    }

    public GroupConcatDistinct groupConcatDistinct(Expression<String> expression, String separator) {
        return new GroupConcatDistinct(expression, null, this.val(separator));
    }

    public GroupConcatDistinct groupConcatDistinct(Expression<String> expression, String separator, OrderingTerm ... order) {
        return new GroupConcatDistinct(expression, Arrays.asList(order), this.val(separator));
    }

    public Sum sum(Expression<Number> expression) {
        return new Sum(expression);
    }

    public Avg avg(Expression<Number> expression) {
        return new Avg(expression);
    }

    public GroupConcat groupConcat(Expression<String> expression) {
        return new GroupConcat(expression, null, null);
    }

    public GroupConcat groupConcat(Expression<String> expression, String separator) {
        return new GroupConcat(expression, null, this.val(separator));
    }

    public GroupConcat groupConcat(Expression<String> expression, String separator, OrderingTerm ... order) {
        return new GroupConcat(expression, Arrays.asList(order), this.val(separator));
    }

    public NumberMax max(NumberExpression expression) {
        return new NumberMax(expression);
    }

    public StringMax max(StringExpression expression) {
        return new StringMax(expression);
    }

    public DateTimeMax max(DateTimeExpression expression) {
        return new DateTimeMax(expression);
    }

    public BooleanMax max(Predicate expression) {
        return new BooleanMax(expression);
    }

    public ByteArrayMax max(ByteArrayExpression expression) {
        return new ByteArrayMax(expression);
    }

    public ObjectMax max(ObjectExpression expression) {
        return new ObjectMax(expression);
    }

    public NumberMin min(NumberExpression expression) {
        return new NumberMin(expression);
    }

    public StringMin min(StringExpression expression) {
        return new StringMin(expression);
    }

    public DateTimeMin min(DateTimeExpression expression) {
        return new DateTimeMin(expression);
    }

    public BooleanMin min(Predicate expression) {
        return new BooleanMin(expression);
    }

    public ByteArrayMin min(ByteArrayExpression expression) {
        return new ByteArrayMin(expression);
    }

    public ObjectMin min(ObjectExpression expression) {
        return new ObjectMin(expression);
    }

    public RowNumber rowNumber() {
        return new RowNumber();
    }

    public Rank rank() {
        return new Rank();
    }

    public DenseRank denseRank() {
        return new DenseRank();
    }

    public NTile ntile() {
        return new NTile();
    }

    public <T> Lead<T> lead(Expression<T> expression) {
        return new Lead(expression, null, null);
    }

    public <T> Lead<T> lead(Expression<T> expression, Number offset) {
        return new Lead(expression, this.val(offset), null);
    }

    public <T> Lead<T> lead(Expression<T> expression, Number offset, Expression<T> defaultValue) {
        return new Lead<T>(expression, this.val(offset), defaultValue);
    }

    public Lead<String> lead(Expression<String> expression, Number offset, String defaultValue) {
        return new Lead<String>(expression, this.val(offset), this.val(defaultValue));
    }

    public Lead<String> lead(Expression<String> expression, Number offset, Character defaultValue) {
        return new Lead<String>(expression, this.val(offset), this.val(defaultValue));
    }

    public Lead<Number> lead(Expression<Number> expression, Number offset, Number defaultValue) {
        return new Lead<Number>(expression, this.val(offset), this.val(defaultValue));
    }

    public Lead<Date> lead(Expression<Date> expression, Number offset, Date defaultValue) {
        return new Lead<Date>(expression, this.val(offset), this.val(defaultValue));
    }

    public Lead<Boolean> lead(Expression<Boolean> expression, Number offset, Boolean defaultValue) {
        return new Lead<Boolean>(expression, this.val(offset), this.val(defaultValue));
    }

    public Lead<byte[]> lead(Expression<byte[]> expression, Number offset, byte[] defaultValue) {
        return new Lead<byte[]>(expression, this.val(offset), this.val(defaultValue));
    }

    public Lead<Object> lead(Expression<Object> expression, Number offset, Object defaultValue) {
        return new Lead<Object>(expression, this.val(offset), this.val(defaultValue));
    }

    public <T> Lag<T> lag(Expression<T> expression) {
        return new Lag(expression, null, null);
    }

    public <T> Lag<T> lag(Expression<T> expression, Number offset) {
        return new Lag(expression, this.val(offset), null);
    }

    public <T> Lag<T> lag(Expression<T> expression, Number offset, Expression<T> defaultValue) {
        return new Lag<T>(expression, this.val(offset), defaultValue);
    }

    public Lag<String> lag(Expression<String> expression, Number offset, String defaultValue) {
        return new Lag<String>(expression, this.val(offset), this.val(defaultValue));
    }

    public Lag<String> lag(Expression<String> expression, Number offset, Character defaultValue) {
        return new Lag<String>(expression, this.val(offset), this.val(defaultValue));
    }

    public Lag<Number> lag(Expression<Number> expression, Number offset, Number defaultValue) {
        return new Lag<Number>(expression, this.val(offset), this.val(defaultValue));
    }

    public Lag<Date> lag(Expression<Date> expression, Number offset, Date defaultValue) {
        return new Lag<Date>(expression, this.val(offset), this.val(defaultValue));
    }

    public Lag<Boolean> lag(Expression<Boolean> expression, Number offset, Boolean defaultValue) {
        return new Lag<Boolean>(expression, this.val(offset), this.val(defaultValue));
    }

    public Lag<byte[]> lag(Expression<byte[]> expression, Number offset, byte[] defaultValue) {
        return new Lag<byte[]>(expression, this.val(offset), this.val(defaultValue));
    }

    public Lag<Object> lag(Expression<Object> expression, Number offset, Object defaultValue) {
        return new Lag<Object>(expression, this.val(offset), this.val(defaultValue));
    }

    public CaseWhenStage<String> caseWhen(Predicate predicate, String value) {
        return new CaseWhenStage<String>(predicate, this.val(value));
    }

    public CaseWhenStage<String> caseWhen(Predicate predicate, Character value) {
        return new CaseWhenStage<String>(predicate, this.val(value));
    }

    public CaseWhenStage<Number> caseWhen(Predicate predicate, Number value) {
        return new CaseWhenStage<Number>(predicate, this.val(value));
    }

    public CaseWhenStage<Date> caseWhen(Predicate predicate, Date value) {
        return new CaseWhenStage<Date>(predicate, this.val(value));
    }

    public CaseWhenStage<Boolean> caseWhen(Predicate predicate, Boolean value) {
        return new CaseWhenStage<Boolean>(predicate, this.val(value));
    }

    public CaseWhenStage<byte[]> caseWhen(Predicate predicate, byte[] value) {
        return new CaseWhenStage<byte[]>(predicate, this.val(value));
    }

    public CaseWhenStage<Object> caseWhen(Predicate predicate, Object value) {
        return new CaseWhenStage<Object>(predicate, this.val(value));
    }

    public DateTimeExpression currentDate() {
        return new CurrentDate();
    }

    public DateTimeExpression currentTime() {
        return new CurrentTime();
    }

    public DateTimeExpression currentDateTime() {
        return new CurrentDateTime();
    }

    public DateTimeExpression datetime(Expression<Date> date, Expression<Date> time) {
        return new DateTime(date, time);
    }

    public StringConstant val(String value) {
        return new StringConstant(value);
    }

    public StringConstant val(Character value) {
        return new StringConstant("" + value);
    }

    public NumberConstant val(Number value) {
        return new NumberConstant(value);
    }

    public DateTimeConstant val(Date value) {
        return new DateTimeConstant(value);
    }

    public BooleanConstant val(Boolean value) {
        return new BooleanConstant(value);
    }

    public ByteArrayConstant val(byte[] value) {
        return new ByteArrayConstant(value);
    }

    public ObjectConstant val(Object value) {
        return new ObjectConstant(value);
    }

    public StringExpression castString(Expression<String> value) {
        return new StringValue(value);
    }

    public NumberExpression castNumber(Expression<Number> value) {
        return new NumberValue(value);
    }

    public DateTimeExpression castDateTime(Expression<Date> value) {
        return new DateTimeValue(value);
    }

    public Predicate castBoolean(Expression<Boolean> value) {
        return new BooleanValue(value);
    }

    public ByteArrayExpression castByteArray(Expression<byte[]> value) {
        return new ByteArrayValue(value);
    }

    public ObjectExpression castObject(Expression<Object> value) {
        return new ObjectValue(value);
    }
}

