/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.dialects;

import java.util.List;
import org.hotrod.runtime.livesql.dialects.FunctionRenderer;
import org.hotrod.runtime.livesql.dialects.IdentifierRenderer;
import org.hotrod.runtime.livesql.dialects.JoinRenderer;
import org.hotrod.runtime.livesql.dialects.PaginationRenderer;
import org.hotrod.runtime.livesql.dialects.SQLDialect;
import org.hotrod.runtime.livesql.dialects.SetOperationRenderer;
import org.hotrod.runtime.livesql.exceptions.InvalidLiveSQLStatementException;
import org.hotrod.runtime.livesql.exceptions.UnsupportedLiveSQLFeatureException;
import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.ordering.OrderingTerm;
import org.hotrod.runtime.livesql.queries.select.CrossJoin;
import org.hotrod.runtime.livesql.queries.select.FullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.InnerJoin;
import org.hotrod.runtime.livesql.queries.select.Join;
import org.hotrod.runtime.livesql.queries.select.LeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalFullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalInnerJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalLeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalRightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;
import org.hotrod.runtime.livesql.queries.select.RightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.UnionJoin;
import org.hotrod.runtime.livesql.util.Separator;

public class DB2Dialect
extends SQLDialect {
    public DB2Dialect(String productName, String productVersion, int majorVersion, int minorVersion) {
        super(productName, productVersion, majorVersion, minorVersion);
    }

    @Override
    public IdentifierRenderer getIdentifierRenderer() {
        return new IdentifierRenderer("[A-Z][A-Z0-9_]*", "\"", "\"", false);
    }

    @Override
    public JoinRenderer getJoinRenderer() {
        return new JoinRenderer(){

            @Override
            public String renderJoinKeywords(Join join) throws UnsupportedLiveSQLFeatureException {
                if (join instanceof InnerJoin) {
                    return "JOIN";
                }
                if (join instanceof LeftOuterJoin) {
                    return "LEFT OUTER JOIN";
                }
                if (join instanceof RightOuterJoin) {
                    return "RIGHT OUTER JOIN";
                }
                if (join instanceof FullOuterJoin) {
                    return "FULL OUTER JOIN";
                }
                if (join instanceof CrossJoin) {
                    return "CROSS JOIN";
                }
                if (join instanceof NaturalInnerJoin) {
                    return "NATURAL JOIN";
                }
                if (join instanceof NaturalLeftOuterJoin) {
                    return "NATURAL LEFT OUTER JOIN";
                }
                if (join instanceof NaturalRightOuterJoin) {
                    return "NATURAL RIGHT OUTER JOIN";
                }
                if (join instanceof NaturalFullOuterJoin) {
                    return "NATURAL FULL OUTER JOIN";
                }
                if (join instanceof UnionJoin) {
                    throw new UnsupportedLiveSQLFeatureException("Union joins are not supported in DB2 database");
                }
                throw new UnsupportedLiveSQLFeatureException("Invalid join type (" + join.getClass().getSimpleName() + ") in DB2 database");
            }
        };
    }

    @Override
    public PaginationRenderer getPaginationRenderer() {
        return new PaginationRenderer(){

            @Override
            public PaginationRenderer.PaginationType getPaginationType(Integer offset, Integer limit) {
                if (offset != null && !DB2Dialect.this.versionIsAtLeast(11, 1)) {
                    throw new UnsupportedLiveSQLFeatureException("This version of DB2 (" + DB2Dialect.this.renderVersion() + ") does not support the OFFSET clause. DB2 versions 11.1 and newer do");
                }
                return PaginationRenderer.PaginationType.BOTTOM;
            }

            @Override
            public void renderTopPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("In DB2 pagination cannot be rendered at the top");
            }

            @Override
            public void renderBottomPagination(Integer offset, Integer limit, QueryWriter w) {
                if (offset != null && !DB2Dialect.this.versionIsAtLeast(11, 1)) {
                    throw new UnsupportedLiveSQLFeatureException("This version of DB2 (" + DB2Dialect.this.renderVersion() + ") does not support the OFFSET clause. Support starts in DB2 11.1");
                }
                if (offset != null) {
                    w.write("\nOFFSET " + offset + " ROWS");
                }
                if (limit != null) {
                    w.write("\nFETCH NEXT " + limit + " ROWS ONLY");
                }
            }

            @Override
            public void renderBeginEnclosingPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("In DB2 pagination cannot be rendered in an enclosing way");
            }

            @Override
            public void renderEndEnclosingPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("In DB2 pagination cannot be rendered in an enclosing way");
            }
        };
    }

    @Override
    public SetOperationRenderer getSetOperationRenderer() {
        return new SetOperationRenderer(){

            @Override
            public void render(SetOperationRenderer.SetOperation setOperation, QueryWriter w) {
                switch (setOperation) {
                    case UNION: {
                        w.write("UNION");
                        break;
                    }
                    case UNION_ALL: {
                        w.write("UNION ALL");
                        break;
                    }
                    case INTERSECT: {
                        w.write("INTERSECT");
                        break;
                    }
                    case INTERSECT_ALL: {
                        w.write("INTERSECT ALL");
                        break;
                    }
                    case EXCEPT: {
                        w.write("EXCEPT");
                        break;
                    }
                    case EXCEPT_ALL: {
                        w.write("EXCEPT ALL");
                        break;
                    }
                    default: {
                        throw new InvalidLiveSQLStatementException("Invalid set operation '" + (Object)((Object)setOperation) + "'.");
                    }
                }
            }
        };
    }

    @Override
    public FunctionRenderer getFunctionRenderer() {
        return new FunctionRenderer(){

            @Override
            public void groupConcat(QueryWriter w, boolean distinct, Expression<String> value, List<OrderingTerm> ordering, Expression<String> separator) {
                if (distinct) {
                    throw new UnsupportedLiveSQLFeatureException("DB2 does not support DISTINCT on the GROUP_CONCAT() function (listagg())");
                }
                w.write("listagg(");
                value.renderTo(w);
                if (separator != null) {
                    w.write(", ");
                    separator.renderTo(w);
                }
                w.write(")");
                if (ordering != null && !ordering.isEmpty()) {
                    w.write(" withing group (ORDER BY ");
                    Separator sep = new Separator();
                    for (OrderingTerm t : ordering) {
                        w.write(sep.render());
                        t.renderTo(w);
                    }
                    w.write(")");
                }
            }

            @Override
            public void logarithm(QueryWriter w, Expression<Number> x, Expression<Number> base) {
                if (base == null) {
                    this.write(w, "ln", x);
                } else {
                    w.write("(");
                    this.write(w, "ln", x);
                    w.write(" / ");
                    this.write(w, "ln", base);
                    w.write(")");
                }
            }

            @Override
            public void currentDate(QueryWriter w) {
                w.write("current date");
            }

            @Override
            public void currentTime(QueryWriter w) {
                w.write("current time");
            }

            @Override
            public void currentDateTime(QueryWriter w) {
                w.write("current timestamp");
            }
        };
    }
}

