/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.dialects;

import java.util.Date;
import java.util.List;
import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.expressions.datetime.DateTimeFieldExpression;
import org.hotrod.runtime.livesql.ordering.OrderingTerm;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;
import org.hotrod.runtime.livesql.util.Separator;

public abstract class FunctionRenderer {
    public <T> void coalesce(QueryWriter w, List<Expression<T>> values) {
        this.write(w, "coalesce", values);
    }

    public void groupConcat(QueryWriter w, boolean distinct, Expression<String> value, List<OrderingTerm> ordering, Expression<String> separator) {
        w.write("group_concat(");
        if (distinct) {
            w.write("distinct ");
        }
        value.renderTo(w);
        if (ordering != null) {
            w.write("ORDER BY ");
            Separator sep = new Separator();
            for (OrderingTerm t : ordering) {
                w.write(sep.render());
                t.renderTo(w);
            }
        }
        if (separator != null) {
            w.write("separator ");
            separator.renderTo(w);
        }
        w.write(")");
    }

    public void power(QueryWriter w, Expression<Number> x, Expression<Number> exponent) {
        this.write(w, "power", x, exponent);
    }

    public void logarithm(QueryWriter w, Expression<Number> x, Expression<Number> base) {
        if (base == null) {
            this.write(w, "log", x);
        } else {
            this.write(w, "log", base, x);
        }
    }

    public void round(QueryWriter w, Expression<Number> x, Expression<Number> places) {
        if (places == null) {
            this.write(w, "round", x);
        } else {
            this.write(w, "round", x, places);
        }
    }

    public void trunc(QueryWriter w, Expression<Number> x, Expression<Number> places) {
        if (places == null) {
            this.write(w, "trunc", x);
        } else {
            this.write(w, "trunc", x, places);
        }
    }

    public void abs(QueryWriter w, Expression<Number> x) {
        this.write(w, "abs", x);
    }

    public void signum(QueryWriter w, Expression<Number> x) {
        this.write(w, "sign", x);
    }

    public void neg(QueryWriter w, Expression<Number> x) {
        this.write(w, "-", x);
    }

    public void concat(QueryWriter w, List<Expression<String>> strings) {
        this.write(w, "concat", strings);
    }

    public void length(QueryWriter w, Expression<String> string) {
        this.write(w, "length", string);
    }

    public void lower(QueryWriter w, Expression<String> string) {
        this.write(w, "lower", string);
    }

    public void upper(QueryWriter w, Expression<String> string) {
        this.write(w, "upper", string);
    }

    public void locate(QueryWriter w, Expression<String> substring, Expression<String> string, Expression<Number> from) {
        if (from == null) {
            this.write(w, "locate", substring, string);
        } else {
            this.write(w, "locate", substring, string, from);
        }
    }

    public void substr(QueryWriter w, Expression<String> string, Expression<Number> from, Expression<Number> length) {
        if (length == null) {
            this.write(w, "substr", string, from);
        } else {
            this.write(w, "substr", string, from, length);
        }
    }

    public void trim(QueryWriter w, Expression<String> string) {
        this.write(w, "trim", string);
    }

    public void currentDate(QueryWriter w) {
        w.write("current_date()");
    }

    public void currentTime(QueryWriter w) {
        w.write("current_time()");
    }

    public void currentDateTime(QueryWriter w) {
        w.write("current_timestamp()");
    }

    public void date(QueryWriter w, Expression<Date> datetime) {
        this.write(w, "date", datetime);
    }

    public void time(QueryWriter w, Expression<Date> datetime) {
        this.write(w, "time", datetime);
    }

    public void dateTime(QueryWriter w, Expression<Date> date, Expression<Date> time) {
        this.write(w, "timestamp", date, time);
    }

    public void extract(QueryWriter w, Expression<Date> datetime, DateTimeFieldExpression field) {
        w.write("extract(");
        field.renderTo(w);
        w.write(" from ");
        datetime.renderTo(w);
        w.write(")");
    }

    protected void write(QueryWriter w, String function, Expression<?> ... expressions) {
        w.write(function);
        w.write("(");
        Separator sep = new Separator();
        for (Expression<?> expr : expressions) {
            w.write(sep.render());
            expr.renderTo(w);
        }
        w.write(")");
    }

    protected <T> void write(QueryWriter w, String function, List<Expression<T>> x) {
        this.write(w, function, x, ", ");
    }

    protected <T> void write(QueryWriter w, String function, List<Expression<T>> x, String separator) {
        w.write(function);
        w.write("(");
        Separator sep = new Separator(separator);
        for (Expression<T> expr : x) {
            w.write(sep.render());
            expr.renderTo(w);
        }
        w.write(")");
    }
}

