/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.dialects;

import java.util.Date;
import org.hotrod.runtime.livesql.dialects.FunctionRenderer;
import org.hotrod.runtime.livesql.dialects.IdentifierRenderer;
import org.hotrod.runtime.livesql.dialects.JoinRenderer;
import org.hotrod.runtime.livesql.dialects.PaginationRenderer;
import org.hotrod.runtime.livesql.dialects.SQLDialect;
import org.hotrod.runtime.livesql.dialects.SetOperationRenderer;
import org.hotrod.runtime.livesql.exceptions.InvalidLiveSQLStatementException;
import org.hotrod.runtime.livesql.exceptions.UnsupportedLiveSQLFeatureException;
import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.queries.select.CrossJoin;
import org.hotrod.runtime.livesql.queries.select.FullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.InnerJoin;
import org.hotrod.runtime.livesql.queries.select.Join;
import org.hotrod.runtime.livesql.queries.select.LeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalFullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalInnerJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalLeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalRightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;
import org.hotrod.runtime.livesql.queries.select.RightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.UnionJoin;

public class HyperSQLDialect
extends SQLDialect {
    public HyperSQLDialect(String productName, String productVersion, int majorVersion, int minorVersion) {
        super(productName, productVersion, majorVersion, minorVersion);
    }

    @Override
    public IdentifierRenderer getIdentifierRenderer() {
        return new IdentifierRenderer("[A-Z][A-Z0-9_]*", "\"", "\"", false);
    }

    @Override
    public JoinRenderer getJoinRenderer() {
        return new JoinRenderer(){

            @Override
            public String renderJoinKeywords(Join join) throws UnsupportedLiveSQLFeatureException {
                if (join instanceof InnerJoin) {
                    return "JOIN";
                }
                if (join instanceof LeftOuterJoin) {
                    return "LEFT OUTER JOIN";
                }
                if (join instanceof RightOuterJoin) {
                    return "RIGHT OUTER JOIN";
                }
                if (join instanceof FullOuterJoin) {
                    return "FULL OUTER JOIN";
                }
                if (join instanceof CrossJoin) {
                    return "CROSS JOIN";
                }
                if (join instanceof NaturalInnerJoin) {
                    return "NATURAL JOIN";
                }
                if (join instanceof NaturalLeftOuterJoin) {
                    return "NATURAL LEFT OUTER JOIN";
                }
                if (join instanceof NaturalRightOuterJoin) {
                    return "NATURAL RIGHT OUTER JOIN";
                }
                if (join instanceof NaturalFullOuterJoin) {
                    return "NATURAL FULL OUTER JOIN";
                }
                if (join instanceof UnionJoin) {
                    return "UNION JOIN";
                }
                throw new UnsupportedLiveSQLFeatureException("Invalid join type (" + join.getClass().getSimpleName() + ") in HyperSQL database");
            }
        };
    }

    @Override
    public PaginationRenderer getPaginationRenderer() {
        return new PaginationRenderer(){

            @Override
            public PaginationRenderer.PaginationType getPaginationType(Integer offset, Integer limit) {
                return offset != null || limit != null ? PaginationRenderer.PaginationType.BOTTOM : null;
            }

            @Override
            public void renderTopPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("Pagination can only be rendered at the bottom in HyperSQL");
            }

            @Override
            public void renderBottomPagination(Integer offset, Integer limit, QueryWriter w) {
                if (limit != null) {
                    if (offset != null) {
                        w.write("\nLIMIT " + limit + " OFFSET " + offset);
                    } else {
                        w.write("\nLIMIT " + limit);
                    }
                } else {
                    w.write("\nOFFSET " + offset);
                }
            }

            @Override
            public void renderBeginEnclosingPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("Pagination can only be rendered at the bottom in HyperSQL");
            }

            @Override
            public void renderEndEnclosingPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("Pagination can only be rendered at the bottom in HyperSQL");
            }
        };
    }

    @Override
    public SetOperationRenderer getSetOperationRenderer() {
        return new SetOperationRenderer(){

            @Override
            public void render(SetOperationRenderer.SetOperation setOperation, QueryWriter w) {
                switch (setOperation) {
                    case UNION: {
                        w.write("UNION");
                        break;
                    }
                    case UNION_ALL: {
                        w.write("UNION ALL");
                        break;
                    }
                    case INTERSECT: {
                        w.write("INTERSECT DISTINCT");
                        break;
                    }
                    case INTERSECT_ALL: {
                        w.write("INTERSECT");
                        break;
                    }
                    case EXCEPT: {
                        w.write("EXCEPT DISTINCT");
                        break;
                    }
                    case EXCEPT_ALL: {
                        w.write("EXCEPT");
                        break;
                    }
                    default: {
                        throw new InvalidLiveSQLStatementException("Invalid set operation '" + (Object)((Object)setOperation) + "'.");
                    }
                }
            }
        };
    }

    @Override
    public FunctionRenderer getFunctionRenderer() {
        return new FunctionRenderer(){

            @Override
            public void logarithm(QueryWriter w, Expression<Number> x, Expression<Number> base) {
                if (base == null) {
                    this.write(w, "ln", x);
                } else {
                    w.write("(");
                    this.write(w, "ln", x);
                    w.write(" / ");
                    this.write(w, "ln", base);
                    w.write(")");
                }
            }

            @Override
            public void round(QueryWriter w, Expression<Number> x, Expression<Number> places) {
                if (places == null) {
                    throw new UnsupportedLiveSQLFeatureException("HyperSQL requires the number of decimal places to be specified when using the ROUND() function");
                }
                this.write(w, "round", x, places);
            }

            @Override
            public void substr(QueryWriter w, Expression<String> string, Expression<Number> from, Expression<Number> length) {
                if (length == null) {
                    throw new UnsupportedLiveSQLFeatureException("HyperSQL requires the length to be specified when using the SUBSTR() function");
                }
                this.write(w, "substr", string, from, length);
            }

            @Override
            public void currentDate(QueryWriter w) {
                w.write("curdate()");
            }

            @Override
            public void currentTime(QueryWriter w) {
                w.write("curtime()");
            }

            @Override
            public void currentDateTime(QueryWriter w) {
                w.write("current_timestamp");
            }

            @Override
            public void date(QueryWriter w, Expression<Date> datetime) {
                w.write("cast(");
                datetime.renderTo(w);
                w.write(" as date)");
            }

            @Override
            public void time(QueryWriter w, Expression<Date> datetime) {
                w.write("cast(");
                datetime.renderTo(w);
                w.write(" as time)");
            }
        };
    }
}

