/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.dialects;

import org.hotrod.runtime.livesql.dialects.FunctionRenderer;
import org.hotrod.runtime.livesql.dialects.IdentifierRenderer;
import org.hotrod.runtime.livesql.dialects.JoinRenderer;
import org.hotrod.runtime.livesql.dialects.PaginationRenderer;
import org.hotrod.runtime.livesql.dialects.SQLDialect;
import org.hotrod.runtime.livesql.dialects.SetOperationRenderer;
import org.hotrod.runtime.livesql.exceptions.InvalidLiveSQLStatementException;
import org.hotrod.runtime.livesql.exceptions.UnsupportedLiveSQLFeatureException;
import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.queries.select.CrossJoin;
import org.hotrod.runtime.livesql.queries.select.FullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.InnerJoin;
import org.hotrod.runtime.livesql.queries.select.Join;
import org.hotrod.runtime.livesql.queries.select.LeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalFullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalInnerJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalLeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalRightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;
import org.hotrod.runtime.livesql.queries.select.RightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.UnionJoin;

public class MariaDBDialect
extends SQLDialect {
    public MariaDBDialect(String productName, String productVersion, int majorVersion, int minorVersion) {
        super(productName, productVersion, majorVersion, minorVersion);
    }

    @Override
    public IdentifierRenderer getIdentifierRenderer() {
        return new IdentifierRenderer("[a-zA-Z][a-zA-Z0-9_]*", "`", "`", true);
    }

    @Override
    public JoinRenderer getJoinRenderer() {
        return new JoinRenderer(){

            @Override
            public String renderJoinKeywords(Join join) throws UnsupportedLiveSQLFeatureException {
                if (join instanceof InnerJoin) {
                    return "JOIN";
                }
                if (join instanceof LeftOuterJoin) {
                    return "LEFT OUTER JOIN";
                }
                if (join instanceof RightOuterJoin) {
                    return "RIGHT OUTER JOIN";
                }
                if (join instanceof FullOuterJoin) {
                    throw new UnsupportedLiveSQLFeatureException("Full outer joins are not supported in MariaDB");
                }
                if (join instanceof CrossJoin) {
                    return "CROSS JOIN";
                }
                if (join instanceof NaturalInnerJoin) {
                    return "NATURAL JOIN";
                }
                if (join instanceof NaturalLeftOuterJoin) {
                    return "NATURAL LEFT OUTER JOIN";
                }
                if (join instanceof NaturalRightOuterJoin) {
                    return "NATURAL RIGHT OUTER JOIN";
                }
                if (join instanceof NaturalFullOuterJoin) {
                    return "NATURAL FULL OUTER JOIN";
                }
                if (join instanceof UnionJoin) {
                    throw new UnsupportedLiveSQLFeatureException("Union joins are not supported in MariaDB database");
                }
                throw new UnsupportedLiveSQLFeatureException("Invalid join type (" + join.getClass().getSimpleName() + ") in MariaDB database");
            }
        };
    }

    @Override
    public PaginationRenderer getPaginationRenderer() {
        return new PaginationRenderer(){

            @Override
            public PaginationRenderer.PaginationType getPaginationType(Integer offset, Integer limit) {
                return offset != null || limit != null ? PaginationRenderer.PaginationType.BOTTOM : null;
            }

            @Override
            public void renderTopPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("Pagination can only be rendered at the bottom in MariaDB");
            }

            @Override
            public void renderBottomPagination(Integer offset, Integer limit, QueryWriter w) {
                if (limit != null) {
                    if (offset != null) {
                        w.write("\nLIMIT " + limit + "\nOFFSET " + offset);
                    } else {
                        w.write("\nLIMIT " + limit);
                    }
                } else {
                    w.write("\nOFFSET " + offset);
                }
            }

            @Override
            public void renderBeginEnclosingPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("Pagination can only be rendered at the bottom in MariaDB");
            }

            @Override
            public void renderEndEnclosingPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("Pagination can only be rendered at the bottom in MariaDB");
            }
        };
    }

    @Override
    public SetOperationRenderer getSetOperationRenderer() {
        return new SetOperationRenderer(){

            @Override
            public void render(SetOperationRenderer.SetOperation setOperation, QueryWriter w) {
                switch (setOperation) {
                    case UNION: {
                        w.write("UNION");
                        break;
                    }
                    case UNION_ALL: {
                        w.write("UNION ALL");
                        break;
                    }
                    case INTERSECT: {
                        if (MariaDBDialect.this.versionIsAtLeast(10, 3)) {
                            w.write("INTERSECT");
                            break;
                        }
                        throw new UnsupportedLiveSQLFeatureException("This version of MariaDB does not support the INTERSECT set operation. It's supported starting on MariaDB 10.3. Nevertheless, it can be simulated using a semi join");
                    }
                    case INTERSECT_ALL: {
                        throw new UnsupportedLiveSQLFeatureException("MariaDB does not support the INTERSECT ALL set operation. Nevertheless, it can be simulated using a semi join");
                    }
                    case EXCEPT: {
                        if (MariaDBDialect.this.versionIsAtLeast(10, 3)) {
                            w.write("EXCEPT");
                            break;
                        }
                        throw new UnsupportedLiveSQLFeatureException("This version of MariaDB does not support the EXCEPT set operation. It's supported starting on MariaDB 10.3. Nevertheless, it can be simulated using an anti join");
                    }
                    case EXCEPT_ALL: {
                        throw new UnsupportedLiveSQLFeatureException("MariaDB does not support the EXCEPT ALL set operation. Nevertheless, it can be simulated using an anti join");
                    }
                    default: {
                        throw new InvalidLiveSQLStatementException("Invalid set operation '" + (Object)((Object)setOperation) + "'.");
                    }
                }
            }
        };
    }

    @Override
    public FunctionRenderer getFunctionRenderer() {
        return new FunctionRenderer(){

            @Override
            public void trunc(QueryWriter w, Expression<Number> x, Expression<Number> places) {
                if (places == null) {
                    this.write(w, "truncate", x);
                } else {
                    this.write(w, "truncate", x, places);
                }
            }

            @Override
            public void currentDate(QueryWriter w) {
                w.write("curdate()");
            }

            @Override
            public void currentTime(QueryWriter w) {
                w.write("curtime()");
            }

            @Override
            public void currentDateTime(QueryWriter w) {
                w.write("now()");
            }
        };
    }
}

