/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.dialects;

import java.util.Date;
import java.util.List;
import org.hotrod.runtime.livesql.dialects.FunctionRenderer;
import org.hotrod.runtime.livesql.dialects.IdentifierRenderer;
import org.hotrod.runtime.livesql.dialects.JoinRenderer;
import org.hotrod.runtime.livesql.dialects.PaginationRenderer;
import org.hotrod.runtime.livesql.dialects.SQLDialect;
import org.hotrod.runtime.livesql.dialects.SetOperationRenderer;
import org.hotrod.runtime.livesql.exceptions.InvalidLiveSQLStatementException;
import org.hotrod.runtime.livesql.exceptions.UnsupportedLiveSQLFeatureException;
import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.ordering.OrderingTerm;
import org.hotrod.runtime.livesql.queries.select.CrossJoin;
import org.hotrod.runtime.livesql.queries.select.FullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.InnerJoin;
import org.hotrod.runtime.livesql.queries.select.Join;
import org.hotrod.runtime.livesql.queries.select.LeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalFullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalInnerJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalLeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalRightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;
import org.hotrod.runtime.livesql.queries.select.RightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.UnionJoin;
import org.hotrod.runtime.livesql.util.Separator;

public class OracleDialect
extends SQLDialect {
    public OracleDialect(String productName, String productVersion, int majorVersion, int minorVersion) {
        super(productName, productVersion, majorVersion, minorVersion);
    }

    @Override
    public IdentifierRenderer getIdentifierRenderer() {
        return new IdentifierRenderer("[A-Z][A-Z0-9_]*", "\"", "\"", false);
    }

    @Override
    public JoinRenderer getJoinRenderer() {
        return new JoinRenderer(){

            @Override
            public String renderJoinKeywords(Join join) throws UnsupportedLiveSQLFeatureException {
                if (join instanceof InnerJoin) {
                    return "JOIN";
                }
                if (join instanceof LeftOuterJoin) {
                    return "LEFT OUTER JOIN";
                }
                if (join instanceof RightOuterJoin) {
                    return "RIGHT OUTER JOIN";
                }
                if (join instanceof FullOuterJoin) {
                    return "FULL OUTER JOIN";
                }
                if (join instanceof CrossJoin) {
                    return "CROSS JOIN";
                }
                if (join instanceof NaturalInnerJoin) {
                    return "NATURAL JOIN";
                }
                if (join instanceof NaturalLeftOuterJoin) {
                    return "NATURAL LEFT OUTER JOIN";
                }
                if (join instanceof NaturalRightOuterJoin) {
                    return "NATURAL RIGHT OUTER JOIN";
                }
                if (join instanceof NaturalFullOuterJoin) {
                    return "NATURAL FULL OUTER JOIN";
                }
                if (join instanceof UnionJoin) {
                    throw new UnsupportedLiveSQLFeatureException("Union joins are not supported in Oracle database");
                }
                throw new UnsupportedLiveSQLFeatureException("Invalid join type (" + join.getClass().getSimpleName() + ") in Oracle database");
            }
        };
    }

    @Override
    public PaginationRenderer getPaginationRenderer() {
        return new PaginationRenderer(){
            private static final String HOTROD_ROWNUM_COLUMN = "_HotRod_RowNum_";

            @Override
            public PaginationRenderer.PaginationType getPaginationType(Integer offset, Integer limit) {
                return OracleDialect.this.versionIsAtLeast(12, 1) ? PaginationRenderer.PaginationType.BOTTOM : PaginationRenderer.PaginationType.ENCLOSE;
            }

            @Override
            public void renderTopPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("Pagination cannot be rendered at the top");
            }

            @Override
            public void renderBottomPagination(Integer offset, Integer limit, QueryWriter w) {
                if (!OracleDialect.this.versionIsAtLeast(12, 1)) {
                    throw new UnsupportedLiveSQLFeatureException("Pagination cannot be rendered at the bottom in this version of Oracle");
                }
                if (offset != null) {
                    w.write("\nOFFSET " + offset + " ROWS");
                }
                if (limit != null) {
                    w.write("\nFETCH NEXT " + limit + " ROWS ONLY");
                }
            }

            @Override
            public void renderBeginEnclosingPagination(Integer offset, Integer limit, QueryWriter w) {
                if (OracleDialect.this.versionIsAtLeast(12, 1)) {
                    throw new UnsupportedLiveSQLFeatureException("Pagination cannot be rendered in an enclosing way in this version of Oracle.");
                }
                if (offset != null) {
                    w.write("SELECT * FROM (");
                    w.enterLevel();
                    w.write("\n");
                }
                w.write("SELECT x.*, rownum as \"_HotRod_RowNum_\" FROM (");
                w.enterLevel();
                w.write("\n");
            }

            @Override
            public void renderEndEnclosingPagination(Integer offset, Integer limit, QueryWriter w) {
                if (OracleDialect.this.versionIsAtLeast(12, 1)) {
                    throw new UnsupportedLiveSQLFeatureException("Pagination cannot be rendered in an enclosing way in this version of Oracle");
                }
                if (limit != null) {
                    w.exitLevel();
                    w.write("\n");
                    w.write(") x WHERE rownum <= " + (offset != null ? "" + offset + " + " : "") + limit);
                } else {
                    w.exitLevel();
                    w.write("\n");
                    w.write(") x");
                }
                if (offset != null) {
                    w.exitLevel();
                    w.write("\n");
                    w.write(") y WHERE \"_HotRod_RowNum_\" > " + offset);
                }
            }
        };
    }

    @Override
    public SetOperationRenderer getSetOperationRenderer() {
        return new SetOperationRenderer(){

            @Override
            public void render(SetOperationRenderer.SetOperation setOperation, QueryWriter w) {
                switch (setOperation) {
                    case UNION: {
                        w.write("UNION");
                        break;
                    }
                    case UNION_ALL: {
                        w.write("UNION ALL");
                        break;
                    }
                    case INTERSECT: {
                        w.write("INTERSECT");
                        break;
                    }
                    case INTERSECT_ALL: {
                        throw new UnsupportedLiveSQLFeatureException("Oracle database does not support the INTERSECT ALL set operation. Nevertheless, it can be simulated using a semi join");
                    }
                    case EXCEPT: {
                        w.write("MINUS");
                        break;
                    }
                    case EXCEPT_ALL: {
                        throw new UnsupportedLiveSQLFeatureException("Oracle database does not support the EXCEPT ALL (MINUS ALL) set operation. Nevertheless, it can be simulated using an anti join");
                    }
                    default: {
                        throw new InvalidLiveSQLStatementException("Invalid set operation '" + (Object)((Object)setOperation) + "'.");
                    }
                }
            }
        };
    }

    @Override
    public FunctionRenderer getFunctionRenderer() {
        return new FunctionRenderer(){

            @Override
            public void groupConcat(QueryWriter w, boolean distinct, Expression<String> value, List<OrderingTerm> ordering, Expression<String> separator) {
                if (distinct) {
                    throw new UnsupportedLiveSQLFeatureException("Oracle does not support DISTINCT on the GROUP_CONCAT() function (listagg())");
                }
                if (ordering == null || ordering.isEmpty()) {
                    throw new UnsupportedLiveSQLFeatureException("In Oracle GROUP_CONCAT() requires ordering columns");
                }
                w.write("listagg(");
                value.renderTo(w);
                if (separator != null) {
                    w.write(", ");
                    separator.renderTo(w);
                }
                w.write(")");
                w.write(" withing group (ORDER BY ");
                Separator sep = new Separator();
                for (OrderingTerm t : ordering) {
                    w.write(sep.render());
                    t.renderTo(w);
                }
                w.write(")");
            }

            @Override
            public void concat(QueryWriter w, List<Expression<String>> strings) {
                w.write("(");
                Separator sep = new Separator(" || ");
                for (Expression<String> s : strings) {
                    w.write(sep.render());
                    s.renderTo(w);
                }
                w.write(")");
            }

            @Override
            public void locate(QueryWriter w, Expression<String> substring, Expression<String> string, Expression<Number> from) {
                if (from == null) {
                    this.write(w, "instr", string, substring);
                } else {
                    this.write(w, "instr", string, substring, from);
                }
            }

            @Override
            public void currentDate(QueryWriter w) {
                w.write("trunc(current_date)");
            }

            @Override
            public void currentTime(QueryWriter w) {
                w.write("to_char(current_date, 'HH24:MI:SS')");
            }

            @Override
            public void currentDateTime(QueryWriter w) {
                w.write("current_timestamp");
            }

            @Override
            public void date(QueryWriter w, Expression<Date> datetime) {
                w.write("trunc(");
                datetime.renderTo(w);
                w.write(")");
            }

            @Override
            public void time(QueryWriter w, Expression<Date> datetime) {
                w.write("to_char(");
                datetime.renderTo(w);
                w.write(", 'HH24:MI:SS')");
            }

            @Override
            public void dateTime(QueryWriter w, Expression<Date> date, Expression<Date> time) {
                w.write("to_date(to_char(");
                date.renderTo(w);
                w.write(", 'yyyymmdd') || ' ' || ");
                time.renderTo(w);
                w.write(", 'yyyymmdd hh24:mi:ss')");
            }
        };
    }
}

