/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.dialects;

import java.util.Date;
import java.util.List;
import org.hotrod.runtime.livesql.dialects.FunctionRenderer;
import org.hotrod.runtime.livesql.dialects.IdentifierRenderer;
import org.hotrod.runtime.livesql.dialects.JoinRenderer;
import org.hotrod.runtime.livesql.dialects.PaginationRenderer;
import org.hotrod.runtime.livesql.dialects.SQLDialect;
import org.hotrod.runtime.livesql.dialects.SetOperationRenderer;
import org.hotrod.runtime.livesql.exceptions.InvalidLiveSQLStatementException;
import org.hotrod.runtime.livesql.exceptions.UnsupportedLiveSQLFeatureException;
import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.ordering.OrderingTerm;
import org.hotrod.runtime.livesql.queries.select.CrossJoin;
import org.hotrod.runtime.livesql.queries.select.FullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.InnerJoin;
import org.hotrod.runtime.livesql.queries.select.Join;
import org.hotrod.runtime.livesql.queries.select.LeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalFullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalInnerJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalLeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalRightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;
import org.hotrod.runtime.livesql.queries.select.RightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.UnionJoin;
import org.hotrod.runtime.livesql.util.Separator;

public class PostgreSQLDialect
extends SQLDialect {
    public PostgreSQLDialect(String productName, String productVersion, int majorVersion, int minorVersion) {
        super(productName, productVersion, majorVersion, minorVersion);
    }

    @Override
    public IdentifierRenderer getIdentifierRenderer() {
        return new IdentifierRenderer("[a-z][a-z0-9_]*", "\"", "\"", false);
    }

    @Override
    public JoinRenderer getJoinRenderer() {
        return new JoinRenderer(){

            @Override
            public String renderJoinKeywords(Join join) throws UnsupportedLiveSQLFeatureException {
                if (join instanceof InnerJoin) {
                    return "JOIN";
                }
                if (join instanceof LeftOuterJoin) {
                    return "LEFT OUTER JOIN";
                }
                if (join instanceof RightOuterJoin) {
                    return "RIGHT OUTER JOIN";
                }
                if (join instanceof FullOuterJoin) {
                    return "FULL OUTER JOIN";
                }
                if (join instanceof CrossJoin) {
                    return "CROSS JOIN";
                }
                if (join instanceof NaturalInnerJoin) {
                    return "NATURAL JOIN";
                }
                if (join instanceof NaturalLeftOuterJoin) {
                    return "NATURAL LEFT OUTER JOIN";
                }
                if (join instanceof NaturalRightOuterJoin) {
                    return "NATURAL RIGHT OUTER JOIN";
                }
                if (join instanceof NaturalFullOuterJoin) {
                    return "NATURAL FULL OUTER JOIN";
                }
                if (join instanceof UnionJoin) {
                    throw new UnsupportedLiveSQLFeatureException("Union joins are not supported in PostgreSQL database");
                }
                throw new UnsupportedLiveSQLFeatureException("Invalid join type (" + join.getClass().getSimpleName() + ") in PostgreSQL database");
            }
        };
    }

    @Override
    public PaginationRenderer getPaginationRenderer() {
        return new PaginationRenderer(){

            @Override
            public PaginationRenderer.PaginationType getPaginationType(Integer offset, Integer limit) {
                return offset != null || limit != null ? PaginationRenderer.PaginationType.BOTTOM : null;
            }

            @Override
            public void renderTopPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("Pagination can only be rendered at the bottom in PostgreSQL");
            }

            @Override
            public void renderBottomPagination(Integer offset, Integer limit, QueryWriter w) {
                if (limit != null) {
                    if (offset != null) {
                        w.write("\nLIMIT " + limit + " OFFSET " + offset);
                    } else {
                        w.write("\nLIMIT " + limit);
                    }
                } else {
                    w.write("\nOFFSET " + offset);
                }
            }

            @Override
            public void renderBeginEnclosingPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("Pagination can only be rendered at the bottom in PostgreSQL");
            }

            @Override
            public void renderEndEnclosingPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("Pagination can only be rendered at the bottom in PostgreSQL");
            }
        };
    }

    @Override
    public SetOperationRenderer getSetOperationRenderer() {
        return new SetOperationRenderer(){

            @Override
            public void render(SetOperationRenderer.SetOperation setOperation, QueryWriter w) {
                switch (setOperation) {
                    case UNION: {
                        w.write("UNION");
                        break;
                    }
                    case UNION_ALL: {
                        w.write("UNION ALL");
                        break;
                    }
                    case INTERSECT: {
                        w.write("INTERSECT");
                        break;
                    }
                    case INTERSECT_ALL: {
                        w.write("INTERSECT ALL");
                        break;
                    }
                    case EXCEPT: {
                        w.write("EXCEPT");
                        break;
                    }
                    case EXCEPT_ALL: {
                        w.write("EXCEPT ALL");
                        break;
                    }
                    default: {
                        throw new InvalidLiveSQLStatementException("Invalid set operation '" + (Object)((Object)setOperation) + "'.");
                    }
                }
            }
        };
    }

    @Override
    public FunctionRenderer getFunctionRenderer() {
        return new FunctionRenderer(){

            @Override
            public void groupConcat(QueryWriter w, boolean distinct, Expression<String> value, List<OrderingTerm> ordering, Expression<String> separator) {
                if (!PostgreSQLDialect.this.versionIsAtLeast(9)) {
                    throw new UnsupportedLiveSQLFeatureException("This PostgreSQL version (" + PostgreSQLDialect.this.renderVersion() + ") does not support the GROUP_CONCAT() function (string_agg()). Only available on PostgreSQL 9.0 or newer");
                }
                if (distinct) {
                    throw new UnsupportedLiveSQLFeatureException("PostgreSQL does not support DISTINCT on the GROUP_CONCAT() function (string_agg())");
                }
                if (separator == null) {
                    throw new UnsupportedLiveSQLFeatureException("PostgreSQL requires the separator to be specified on the GROUP_CONCAT() function (string_agg())");
                }
                w.write("string_agg(");
                value.renderTo(w);
                w.write(", ");
                separator.renderTo(w);
                if (ordering != null && !ordering.isEmpty()) {
                    w.write(" ORDER BY ");
                    Separator sep = new Separator();
                    for (OrderingTerm t : ordering) {
                        w.write(sep.render());
                        t.renderTo(w);
                    }
                }
                w.write(")");
            }

            @Override
            public void logarithm(QueryWriter w, Expression<Number> x, Expression<Number> base) {
                if (base == null) {
                    this.write(w, "ln", x);
                } else {
                    this.write(w, "log", base, x);
                }
            }

            @Override
            public void locate(QueryWriter w, Expression<String> substring, Expression<String> string, Expression<Number> from) {
                if (from != null) {
                    throw new UnsupportedLiveSQLFeatureException("PostgreSQL does not support the parameter 'from' in the LOCATE function ('strpos' in PostgreSQL lingo)");
                }
                this.write(w, "strpos", string, substring);
            }

            @Override
            public void currentDate(QueryWriter w) {
                w.write("current_date");
            }

            @Override
            public void currentTime(QueryWriter w) {
                w.write("current_time");
            }

            @Override
            public void currentDateTime(QueryWriter w) {
                w.write("current_timestamp");
            }

            @Override
            public void date(QueryWriter w, Expression<Date> datetime) {
                datetime.renderTo(w);
                w.write("::date");
            }

            @Override
            public void time(QueryWriter w, Expression<Date> datetime) {
                datetime.renderTo(w);
                w.write("::time");
            }

            @Override
            public void dateTime(QueryWriter w, Expression<Date> date, Expression<Date> time) {
                w.write("(");
                date.renderTo(w);
                w.write(" + ");
                time.renderTo(w);
                w.write(")");
            }
        };
    }
}

