/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import org.hotrod.runtime.livesql.expressions.AliasedExpression;
import org.hotrod.runtime.livesql.expressions.ResultSetColumn;
import org.hotrod.runtime.livesql.expressions.asymmetric.EqAll;
import org.hotrod.runtime.livesql.expressions.asymmetric.EqAny;
import org.hotrod.runtime.livesql.expressions.asymmetric.GeAll;
import org.hotrod.runtime.livesql.expressions.asymmetric.GeAny;
import org.hotrod.runtime.livesql.expressions.asymmetric.GtAll;
import org.hotrod.runtime.livesql.expressions.asymmetric.GtAny;
import org.hotrod.runtime.livesql.expressions.asymmetric.InSubquery;
import org.hotrod.runtime.livesql.expressions.asymmetric.LeAll;
import org.hotrod.runtime.livesql.expressions.asymmetric.LeAny;
import org.hotrod.runtime.livesql.expressions.asymmetric.LtAll;
import org.hotrod.runtime.livesql.expressions.asymmetric.LtAny;
import org.hotrod.runtime.livesql.expressions.asymmetric.NeAll;
import org.hotrod.runtime.livesql.expressions.asymmetric.NeAny;
import org.hotrod.runtime.livesql.expressions.asymmetric.NotInSubquery;
import org.hotrod.runtime.livesql.expressions.predicates.Between;
import org.hotrod.runtime.livesql.expressions.predicates.Equal;
import org.hotrod.runtime.livesql.expressions.predicates.GreaterThan;
import org.hotrod.runtime.livesql.expressions.predicates.GreaterThanOrEqualTo;
import org.hotrod.runtime.livesql.expressions.predicates.InList;
import org.hotrod.runtime.livesql.expressions.predicates.IsNotNull;
import org.hotrod.runtime.livesql.expressions.predicates.IsNull;
import org.hotrod.runtime.livesql.expressions.predicates.LessThan;
import org.hotrod.runtime.livesql.expressions.predicates.LessThanOrEqualTo;
import org.hotrod.runtime.livesql.expressions.predicates.NotBetween;
import org.hotrod.runtime.livesql.expressions.predicates.NotEqual;
import org.hotrod.runtime.livesql.expressions.predicates.NotInList;
import org.hotrod.runtime.livesql.expressions.predicates.Predicate;
import org.hotrod.runtime.livesql.ordering.OrderByDirectionStage;
import org.hotrod.runtime.livesql.queries.select.AbstractSelect;
import org.hotrod.runtime.livesql.queries.select.ExecutableSelect;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;
import org.hotrod.runtime.livesql.util.BoxUtil;

public abstract class Expression<T>
implements ResultSetColumn {
    public static final int PRECEDENCE_LITERAL = 1;
    public static final int PRECEDENCE_COLUMN = 1;
    public static final int PRECEDENCE_PARENTHESIS = 1;
    public static final int PRECEDENCE_CASE = 2;
    public static final int PRECEDENCE_FUNCTION = 2;
    public static final int PRECEDENCE_TUPLE = 2;
    public static final int PRECEDENCE_UNARY_MINUS = 2;
    public static final int PRECEDENCE_MULT_DIV_MOD = 3;
    public static final int PRECEDENCE_PLUS_MINUS = 4;
    public static final int PRECEDENCE_BETWEEN = 6;
    public static final int PRECEDENCE_EQ_NE_LT_LE_GT_GE = 6;
    public static final int PRECEDENCE_LIKE = 6;
    public static final int PRECEDENCE_IS_NULL = 6;
    public static final int PRECEDENCE_IN = 6;
    public static final int PRECEDENCE_EXISTS = 6;
    public static final int PRECEDENCE_ANY_ALL_EQ_NE_LT_LE_GT_GE = 6;
    public static final int PRECEDENCE_NOT = 10;
    public static final int PRECEDENCE_AND = 11;
    public static final int PRECEDENCE_OR = 12;
    private int precedence;

    protected void setPrecedence(int precedence) {
        this.precedence = precedence;
    }

    protected Expression(int precedence) {
        this.precedence = precedence;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public abstract void validateTableReferences(AbstractSelect.TableReferences var1, AbstractSelect.AliasGenerator var2);

    public abstract void designateAliases(AbstractSelect.AliasGenerator var1);

    public final OrderByDirectionStage asc() {
        return new OrderByDirectionStage(this, true);
    }

    public final OrderByDirectionStage desc() {
        return new OrderByDirectionStage(this, false);
    }

    public Predicate eq(Expression<T> e) {
        return new Equal(this, e);
    }

    public Predicate eq(T value) {
        return new Equal(this, BoxUtil.boxTyped(value));
    }

    public Predicate ne(Expression<T> e) {
        return new NotEqual(this, e);
    }

    public Predicate ne(T value) {
        return new NotEqual(this, BoxUtil.boxTyped(value));
    }

    public Predicate gt(Expression<T> e) {
        return new GreaterThan(this, e);
    }

    public Predicate gt(T value) {
        return new GreaterThan(this, BoxUtil.boxTyped(value));
    }

    public Predicate ge(Expression<T> e) {
        return new GreaterThanOrEqualTo(this, e);
    }

    public Predicate ge(T value) {
        return new GreaterThanOrEqualTo(this, BoxUtil.boxTyped(value));
    }

    public Predicate lt(Expression<T> e) {
        return new LessThan(this, e);
    }

    public Predicate lt(T value) {
        return new LessThan(this, BoxUtil.boxTyped(value));
    }

    public Predicate le(Expression<T> e) {
        return new LessThanOrEqualTo(this, e);
    }

    public Predicate le(T value) {
        return new LessThanOrEqualTo(this, BoxUtil.boxTyped(value));
    }

    public Predicate between(Expression<T> from, Expression<T> to) {
        return new Between(this, from, to);
    }

    public Predicate between(Expression<T> from, T to) {
        return new Between(this, from, BoxUtil.boxTyped(to));
    }

    public Predicate between(T from, Expression<T> to) {
        return new Between(this, BoxUtil.boxTyped(from), to);
    }

    public Predicate between(T from, T to) {
        return new Between(this, BoxUtil.boxTyped(from), BoxUtil.boxTyped(to));
    }

    public Predicate notBetween(Expression<T> from, Expression<T> to) {
        return new NotBetween(this, from, to);
    }

    public Predicate notBetween(Expression<T> from, T to) {
        return new NotBetween(this, from, BoxUtil.boxTyped(to));
    }

    public Predicate notBetween(T from, Expression<T> to) {
        return new NotBetween(this, BoxUtil.boxTyped(from), to);
    }

    public Predicate notBetween(T from, T to) {
        return new NotBetween(this, BoxUtil.boxTyped(from), BoxUtil.boxTyped(to));
    }

    public Predicate isNotNull() {
        return new IsNotNull(this);
    }

    public Predicate isNull() {
        return new IsNull(this);
    }

    public Predicate in(Expression<T> ... values) {
        return new InList<T>(this, Arrays.asList(values));
    }

    public Predicate in(T ... values) {
        ArrayList list = new ArrayList();
        for (T t : values) {
            list.add(BoxUtil.boxTyped(t));
        }
        return new InList(this, list);
    }

    public Predicate notIn(Expression<T> ... values) {
        return new NotInList<T>(this, Arrays.asList(values));
    }

    public Predicate notIn(T ... values) {
        ArrayList list = new ArrayList();
        for (T t : values) {
            list.add(BoxUtil.boxTyped(t));
        }
        return new NotInList(this, list);
    }

    public Predicate in(ExecutableSelect subquery) {
        return new InSubquery(this, subquery);
    }

    public Predicate notIn(ExecutableSelect subquery) {
        return new NotInSubquery(this, subquery);
    }

    public Predicate eqAny(ExecutableSelect subquery) {
        return new EqAny(this, subquery);
    }

    public Predicate neAny(ExecutableSelect subquery) {
        return new NeAny(this, subquery);
    }

    public Predicate ltAny(ExecutableSelect subquery) {
        return new LtAny(this, subquery);
    }

    public Predicate leAny(ExecutableSelect subquery) {
        return new LeAny(this, subquery);
    }

    public Predicate gtAny(ExecutableSelect subquery) {
        return new GtAny(this, subquery);
    }

    public Predicate geAny(ExecutableSelect subquery) {
        return new GeAny(this, subquery);
    }

    public Predicate eqAll(ExecutableSelect subquery) {
        return new EqAll(this, subquery);
    }

    public Predicate neAll(ExecutableSelect subquery) {
        return new NeAll(this, subquery);
    }

    public Predicate ltAll(ExecutableSelect subquery) {
        return new LtAll(this, subquery);
    }

    public Predicate leAll(ExecutableSelect subquery) {
        return new LeAll(this, subquery);
    }

    public Predicate gtAll(ExecutableSelect subquery) {
        return new GtAll(this, subquery);
    }

    public Predicate geAll(ExecutableSelect subquery) {
        return new GeAll(this, subquery);
    }

    public AliasedExpression as(String alias) {
        return new AliasedExpression(this, alias);
    }

    protected void renderInner(Expression<?> inner, QueryWriter w) {
        boolean parenthesis;
        boolean bl = parenthesis = inner.getPrecedence() > this.precedence;
        if (parenthesis) {
            w.write("(");
        }
        inner.renderTo(w);
        if (parenthesis) {
            w.write(")");
        }
    }

    @Override
    public abstract void renderTo(QueryWriter var1);
}

