/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.expressions;

import java.util.ArrayDeque;
import java.util.Deque;

public class ExpressionWriter {
    private boolean multiLineexpressions;
    private int level;
    private boolean atStartOfLine;
    private StringBuilder sb;
    private Deque<Marker> stack;
    private boolean separatorWritten;
    private String leftMargin;

    public ExpressionWriter(boolean multiLineExpressions) {
        this.multiLineexpressions = multiLineExpressions;
        this.level = 0;
        this.atStartOfLine = true;
        this.sb = new StringBuilder();
        this.stack = new ArrayDeque<Marker>();
        this.separatorWritten = true;
        this.leftMargin = "";
        this.log("::constructor #1: this.multiLine=" + this.multiLineexpressions);
    }

    public ExpressionWriter(boolean multiLine, int leftIndent, boolean marginFirstLine) {
        this.multiLineexpressions = multiLine;
        this.level = 0;
        this.atStartOfLine = marginFirstLine;
        this.sb = new StringBuilder();
        this.stack = new ArrayDeque<Marker>();
        this.separatorWritten = true;
        this.leftMargin = this.repeat('x', leftIndent);
        this.log("::constructor #2: this.multiLine=" + this.multiLineexpressions);
    }

    public void enterLevel(boolean parenthesis, boolean inLine) {
        this.log("enterLevel(" + parenthesis + ")");
        if (parenthesis) {
            this.text("(");
        }
        this.stack.push(new Marker(parenthesis, inLine));
        ++this.level;
        if (this.multiLineexpressions && !inLine) {
            this.newLine();
            this.atStartOfLine = true;
        }
    }

    public void exitLevel() {
        this.log("exitLevel()");
        Marker marker = this.stack.pop();
        --this.level;
        if (this.multiLineexpressions && !marker.inLine) {
            this.newLine();
            this.indent();
        }
        if (marker.parenthesis) {
            this.text(")");
        }
    }

    private void separator() {
        this.log(" --- separator() " + (this.separatorWritten ? "-" : "X") + " ---");
        if (!this.separatorWritten) {
            if (this.atStartOfLine && this.multiLineexpressions) {
                this.indent();
            }
            this.sb.append(" ");
            this.separatorWritten = true;
        }
    }

    public void connector(String txt) {
        this.log("connector(" + txt + ")");
        if (txt == null || txt.isEmpty()) {
            return;
        }
        this.separator();
        this.text(txt);
        this.separator();
    }

    public void text(String txt) {
        this.log("'" + txt + "'");
        if (txt == null || txt.isEmpty()) {
            return;
        }
        String[] lines = txt.split("\n");
        if (lines != null) {
            for (int i = 0; i < lines.length; ++i) {
                if (i > 0) {
                    this.newLine();
                    this.indent();
                }
                String l = lines[i].trim();
                if (this.atStartOfLine && this.multiLineexpressions) {
                    this.indent();
                }
                this.sb.append(l);
                this.separatorWritten = false;
            }
        }
    }

    private void newLine() {
        this.log("-newLine()");
        this.sb.append("\n");
        this.separatorWritten = false;
    }

    private void indent() {
        this.atStartOfLine = false;
        this.sb.append(this.leftMargin);
        for (int i = 0; i < this.level * 2; ++i) {
            this.sb.append(".");
        }
        this.separatorWritten = true;
    }

    private String repeat(char c, int times) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public String render() {
        this.log("render()");
        return this.sb.toString();
    }

    private void log(String txt) {
    }

    private static class Marker {
        boolean parenthesis;
        boolean inLine;

        public Marker(boolean parenthesis, boolean inLine) {
            this.parenthesis = parenthesis;
            this.inLine = inLine;
        }
    }
}

