/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.expressions.asymmetric;

import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.expressions.predicates.Predicate;
import org.hotrod.runtime.livesql.queries.select.AbstractSelect;
import org.hotrod.runtime.livesql.queries.select.ExecutableSelect;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;

public abstract class AsymmetricOperator
extends Predicate {
    private Expression<?> value;
    private String operator;
    private ExecutableSelect subquery;

    protected AsymmetricOperator(Expression<?> value, String operator, ExecutableSelect subquery) {
        super(6);
        this.value = value;
        this.operator = operator;
        this.subquery = subquery;
    }

    @Override
    public void renderTo(QueryWriter w) {
        super.renderInner(this.value, w);
        w.write(" " + this.operator + " (\n");
        w.enterLevel();
        this.subquery.renderTo(w);
        w.exitLevel();
        w.write("\n)");
    }

    @Override
    public void validateTableReferences(AbstractSelect.TableReferences tableReferences, AbstractSelect.AliasGenerator ag) {
        this.value.validateTableReferences(tableReferences, ag);
        this.subquery.validateTableReferences(tableReferences, ag);
    }

    @Override
    public void designateAliases(AbstractSelect.AliasGenerator ag) {
        this.value.designateAliases(ag);
        this.subquery.designateAliases(ag);
    }
}

