/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.expressions.general;

import java.util.Date;
import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.queries.select.AbstractSelect;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;

public class Constant<T>
extends Expression<T> {
    private static final int MAX_LITERAL_STRING_LENGTH = 250;
    private static final String SQL_INJECTION_PATTERN = ".*[\\x01-\\x1f'\\x7f-\\x9f\"].*";
    private T value;
    private boolean parameterize;

    public Constant(T value) {
        super(1);
        String s;
        this.parameterize = this.isString(value) ? ((s = (String)value).length() > 250 ? true : s.matches(SQL_INJECTION_PATTERN)) : (this.isNumber(value) ? this.isFloat(value) || this.isDouble(value) : (this.isDateTime(value) ? true : (this.isBoolean(value) ? false : (this.isByteArray(value) ? true : true))));
        this.value = value;
    }

    private boolean isString(T n) {
        try {
            String.class.cast(n);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private boolean isNumber(T n) {
        try {
            Number.class.cast(n);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private boolean isFloat(T n) {
        try {
            Float.class.cast(n);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private boolean isDouble(T n) {
        try {
            Double.class.cast(n);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private boolean isDateTime(T n) {
        try {
            Date.class.cast(n);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private boolean isBoolean(T n) {
        try {
            Boolean.class.cast(n);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private boolean isByteArray(T n) {
        try {
            byte[].class.cast(n);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public void renderTo(QueryWriter w) {
        if (this.parameterize) {
            String name = w.registerParameter(this.value);
            w.write("#{" + name);
            w.write("}");
        } else if (this.value instanceof String) {
            w.write("'" + this.value + "'");
        } else {
            w.write("" + this.value);
        }
    }

    @Override
    public void validateTableReferences(AbstractSelect.TableReferences tableReferences, AbstractSelect.AliasGenerator ag) {
    }

    @Override
    public void designateAliases(AbstractSelect.AliasGenerator ag) {
    }
}

