/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.expressions.predicates;

import java.util.List;
import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.expressions.predicates.Predicate;
import org.hotrod.runtime.livesql.queries.select.AbstractSelect;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;
import org.hotrod.runtime.livesql.util.Separator;

public class NotInList<T>
extends Predicate {
    private Expression<T> value;
    private List<Expression<T>> expressions;

    public NotInList(Expression<T> value, List<Expression<T>> list) {
        super(6);
        this.value = value;
        this.expressions = list;
    }

    @Override
    public void renderTo(QueryWriter w) {
        super.renderInner(this.value, w);
        w.write(" not in (");
        Separator sep = new Separator();
        for (Expression<T> e : this.expressions) {
            w.write(sep.render());
            super.renderInner(e, w);
        }
        w.write(")");
    }

    @Override
    public void validateTableReferences(AbstractSelect.TableReferences tableReferences, AbstractSelect.AliasGenerator ag) {
        for (Expression<T> e : this.expressions) {
            e.validateTableReferences(tableReferences, ag);
        }
    }

    @Override
    public void designateAliases(AbstractSelect.AliasGenerator ag) {
        for (Expression<T> e : this.expressions) {
            e.designateAliases(ag);
        }
    }
}

