/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.expressions.strings;

import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.expressions.numbers.NumberConstant;
import org.hotrod.runtime.livesql.expressions.numbers.NumberExpression;
import org.hotrod.runtime.livesql.expressions.predicates.Like;
import org.hotrod.runtime.livesql.expressions.predicates.NotLike;
import org.hotrod.runtime.livesql.expressions.predicates.Predicate;
import org.hotrod.runtime.livesql.expressions.strings.Concat;
import org.hotrod.runtime.livesql.expressions.strings.Length;
import org.hotrod.runtime.livesql.expressions.strings.Locate;
import org.hotrod.runtime.livesql.expressions.strings.Lower;
import org.hotrod.runtime.livesql.expressions.strings.StringCoalesce;
import org.hotrod.runtime.livesql.expressions.strings.StringConstant;
import org.hotrod.runtime.livesql.expressions.strings.Substring;
import org.hotrod.runtime.livesql.expressions.strings.Trim;
import org.hotrod.runtime.livesql.expressions.strings.Upper;

public abstract class StringExpression
extends Expression<String> {
    protected StringExpression(int precedence) {
        super(precedence);
    }

    public StringExpression coalesce(StringExpression a) {
        return new StringCoalesce(this, a);
    }

    public StringExpression coalesce(String a) {
        return new StringCoalesce(this, new StringConstant(a));
    }

    public NumberExpression locate(Expression<String> substring, Expression<Number> from) {
        return new Locate(substring, this, from);
    }

    public NumberExpression locate(Expression<String> substring, Number from) {
        return new Locate(substring, this, new NumberConstant(from));
    }

    public NumberExpression locate(String substring, Expression<Number> from) {
        return new Locate(new StringConstant(substring), this, from);
    }

    public NumberExpression locate(String substring, Number from) {
        return new Locate(new StringConstant(substring), this, new NumberConstant(from));
    }

    public NumberExpression locate(Expression<String> substring) {
        return new Locate(substring, this, new NumberConstant((Number)0));
    }

    public NumberExpression locate(String substring) {
        return new Locate(new StringConstant(substring), this, new NumberConstant((Number)0));
    }

    public StringExpression substr(Expression<Number> from, Expression<Number> length) {
        return new Substring(this, from, length);
    }

    public StringExpression substr(Expression<Number> from, Number length) {
        return new Substring(this, from, new NumberConstant(length));
    }

    public StringExpression substr(Number from, Expression<Number> length) {
        return new Substring(this, new NumberConstant(from), length);
    }

    public StringExpression substr(Number from, Number length) {
        return new Substring(this, new NumberConstant(from), new NumberConstant(length));
    }

    public StringExpression substr(Expression<Number> from) {
        return new Substring(this, from);
    }

    public StringExpression substr(Number from) {
        return new Substring(this, new NumberConstant(from));
    }

    public StringExpression concat(Expression<String> e) {
        Concat concat = new Concat(this, e);
        return concat;
    }

    public StringExpression concat(String e) {
        Concat concat = new Concat(this, new StringConstant(e));
        return concat;
    }

    public NumberExpression length() {
        return new Length(this);
    }

    public StringExpression lower() {
        return new Lower(this);
    }

    public StringExpression upper() {
        return new Upper(this);
    }

    public StringExpression trim() {
        return new Trim(this);
    }

    public Predicate like(Expression<String> e) {
        return new Like(this, e);
    }

    public Predicate like(String value) {
        return new Like(this, new StringConstant(value));
    }

    public Predicate like(Expression<String> e, Expression<String> escape) {
        return new Like(this, e, escape);
    }

    public Predicate like(Expression<String> e, String escape) {
        return new Like(this, e, new StringConstant(escape));
    }

    public Predicate like(String e, Expression<String> escape) {
        return new Like(this, new StringConstant(e), escape);
    }

    public Predicate like(String e, String escape) {
        return new Like(this, new StringConstant(e), new StringConstant(escape));
    }

    public Predicate notLike(Expression<String> e) {
        return new NotLike(this, e);
    }

    public Predicate notLike(String e) {
        return new NotLike(this, new StringConstant(e));
    }

    public Predicate notLike(Expression<String> e, Expression<String> escape) {
        return new NotLike(this, e, escape);
    }

    public Predicate notLike(Expression<String> e, String escape) {
        return new NotLike(this, e, new StringConstant(escape));
    }

    public Predicate notLike(String e, Expression<String> escape) {
        return new NotLike(this, new StringConstant(e), escape);
    }

    public Predicate notLike(String e, String escape) {
        return new NotLike(this, new StringConstant(e), new StringConstant(escape));
    }
}

