/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.queries.select;

import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.hotrod.runtime.livesql.dialects.SQLDialect;
import org.hotrod.runtime.livesql.expressions.ResultSetColumn;
import org.hotrod.runtime.livesql.metadata.Column;
import org.hotrod.runtime.livesql.queries.select.AbstractSelect;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;
import org.hotrod.runtime.livesql.util.Separator;

class CombinedSelect<T>
extends AbstractSelect<T> {
    private List<ResultSetColumn> resultSetColumns = null;

    CombinedSelect(SQLDialect sqlDialect, boolean distinct, SqlSession sqlSession) {
        super(sqlDialect, distinct, sqlSession, null);
    }

    CombinedSelect(SQLDialect sqlDialect, boolean distinct, SqlSession sqlSession, String mapperStatement) {
        super(sqlDialect, distinct, sqlSession, mapperStatement);
    }

    void setResultSetColumns(List<ResultSetColumn> resultSetColumns) {
        this.resultSetColumns = resultSetColumns;
    }

    @Override
    protected void writeColumns(QueryWriter w) {
        if (this.resultSetColumns == null || this.resultSetColumns.isEmpty()) {
            w.write("\n  *");
        } else {
            Separator sep = new Separator();
            for (ResultSetColumn c : this.resultSetColumns) {
                w.write(sep.render());
                w.write("\n  ");
                c.renderTo(w);
                try {
                    Column col = (Column)c;
                    w.write(" as ");
                    w.write(w.getSqlDialect().getIdentifierRenderer().renderSQLName(col.getProperty()));
                }
                catch (ClassCastException classCastException) {}
            }
        }
    }
}

