/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.spring;

import java.util.List;
import java.util.Properties;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringBeanObjectFactory
implements ObjectFactory,
ApplicationContextAware {
    private DefaultObjectFactory defaultObjectFactory = new DefaultObjectFactory();
    private ApplicationContext applicationContext = null;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public <T> T create(Class<T> type) {
        try {
            return (T)this.applicationContext.getBean(type);
        }
        catch (NoSuchBeanDefinitionException e) {
            return (T)this.defaultObjectFactory.create(type);
        }
    }

    public <T> T create(Class<T> type, List<Class<?>> constructorArgTypes, List<Object> constructorArgs) {
        try {
            return (T)this.applicationContext.getBean(type, constructorArgs.toArray());
        }
        catch (NoSuchBeanDefinitionException e) {
            return (T)this.defaultObjectFactory.create(type, constructorArgTypes, constructorArgs);
        }
    }

    public <T> boolean isCollection(Class<T> type) {
        return this.defaultObjectFactory.isCollection(type);
    }

    public void setProperties(Properties properties) {
    }
}

