/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.tx;

import java.sql.SQLException;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class TxManager {
    private SqlSessionFactory sqlSessionFactory;
    private static final ThreadLocal<HotRodSqlSession> HOTROD_SQL_SESSION = new ThreadLocal<HotRodSqlSession>(){

        @Override
        public HotRodSqlSession initialValue() {
            return null;
        }
    };

    public TxManager(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    private HotRodSqlSession getHotRodSqlSession() throws SQLException {
        return this.prepare(null);
    }

    private HotRodSqlSession getHotrodSqlSession(SqlSession sqlSession) throws SQLException {
        return this.prepare(sqlSession);
    }

    private HotRodSqlSession prepare(SqlSession sqlSession) throws SQLException {
        try {
            HotRodSqlSession es = HOTROD_SQL_SESSION.get();
            if (es == null) {
                SqlSession newSqlSession = sqlSession != null ? sqlSession : this.sqlSessionFactory.openSession();
                es = new HotRodSqlSession(newSqlSession);
                HOTROD_SQL_SESSION.set(es);
            } else if (sqlSession != null) {
                es.sqlSession = sqlSession;
                es.isTransactionOngoing = true;
            } else if (es.sqlSession == null) {
                es.sqlSession = this.sqlSessionFactory.openSession();
            }
            return es;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public void begin() throws SQLException {
        HotRodSqlSession es = this.getHotRodSqlSession();
        es.setTransactionOngoing(true);
    }

    public void begin(SqlSession sqlSession) throws SQLException {
        HotRodSqlSession es = this.getHotrodSqlSession(sqlSession);
        es.setTransactionOngoing(true);
    }

    public boolean isTransactionOngoing() throws SQLException {
        return this.getHotRodSqlSession().isTransactionOngoing();
    }

    public void commit() throws SQLException {
        this.getSqlSession().commit();
        TxManager.markTransactionAsEnded();
    }

    public SqlSession getSqlSession() throws SQLException {
        return this.getHotRodSqlSession().getSqlSession();
    }

    public void rollback() throws SQLException {
        this.getSqlSession().rollback();
        TxManager.markTransactionAsEnded();
    }

    public void close() throws SQLException {
        try {
            HotRodSqlSession es = this.getHotRodSqlSession();
            SqlSession sqlSession = es.getSqlSession();
            if (sqlSession != null) {
                sqlSession.close();
                es.sqlSession = null;
            }
            TxManager.markTransactionAsEnded();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private static void markTransactionAsEnded() {
        HotRodSqlSession es = HOTROD_SQL_SESSION.get();
        es.setTransactionOngoing(false);
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public static class HotRodSqlSession {
        private SqlSession sqlSession;
        private boolean isTransactionOngoing;

        public HotRodSqlSession(SqlSession sqlSession) {
            this.sqlSession = sqlSession;
            this.isTransactionOngoing = false;
        }

        public boolean isTransactionOngoing() {
            return this.isTransactionOngoing;
        }

        void setTransactionOngoing(boolean isTransactionOngoing) {
            this.isTransactionOngoing = isTransactionOngoing;
        }

        public SqlSession getSqlSession() {
            return this.sqlSession;
        }
    }
}

