/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ListWriter {
    private String prefix;
    private String elemPrefix;
    private String elemSuffix;
    private String separator;
    private String lastSeparator;
    private String suffix;
    private int rendered;
    private int added;
    private String last;
    private StringBuilder sb;
    private String result;

    public ListWriter(String separator) {
        this.initialize("", "", "", separator, separator, "");
    }

    public ListWriter(String separator, String lastSeparator) {
        this.initialize("", "", "", separator, lastSeparator, "");
    }

    public ListWriter(String elemPrefix, String elemSuffix, String separator) {
        this.initialize(null, elemPrefix, elemSuffix, separator, separator, null);
    }

    public ListWriter(String elemPrefix, String elemSuffix, String separator, String lastSeparator) {
        this.initialize(null, elemPrefix, elemSuffix, separator, lastSeparator, null);
    }

    public ListWriter(String prefix, String elemPrefix, String elemSuffix, String separator, String suffix) {
        this.initialize(prefix, elemPrefix, elemSuffix, separator, separator, suffix);
    }

    public ListWriter(String prefix, String elemPrefix, String elemSuffix, String separator, String lastSeparator, String suffix) {
        this.initialize(prefix, elemPrefix, elemSuffix, separator, lastSeparator, suffix);
    }

    private void initialize(String prefix, String elemPrefix, String elemSuffix, String separator, String lastSeparator, String suffix) {
        this.prefix = prefix == null ? "" : prefix;
        this.elemPrefix = elemPrefix == null ? "" : elemPrefix;
        this.elemSuffix = elemSuffix == null ? "" : elemSuffix;
        this.separator = separator == null ? "" : separator;
        this.lastSeparator = lastSeparator == null ? "" : lastSeparator;
        this.suffix = suffix == null ? "" : suffix;
        this.rendered = 0;
        this.last = null;
        this.sb = new StringBuilder();
        this.result = null;
        this.added = 0;
        this.sb.append(this.prefix);
    }

    public void add(String txt) {
        if (this.result != null) {
            throw new IllegalStateException("The String was already rendered and cannot be modified.");
        }
        if (txt == null) {
            throw new IllegalArgumentException("Cannot add a null element to a " + ListWriter.class.getName() + ".");
        }
        if (this.last == null) {
            this.last = txt;
        } else {
            this.renderElement(this.last, false);
            this.last = txt;
        }
        ++this.added;
    }

    private void renderElement(String txt, boolean isLast) {
        if (this.rendered > 0) {
            this.sb.append(isLast ? this.lastSeparator : this.separator);
        }
        this.sb.append(this.elemPrefix);
        this.sb.append(txt);
        this.sb.append(this.elemSuffix);
        ++this.rendered;
    }

    public String toString() {
        if (this.result == null) {
            if (this.last != null) {
                this.renderElement(this.last, true);
            }
            this.sb.append(this.suffix);
            this.result = this.sb.toString();
        }
        return this.result;
    }

    public int getCount() {
        return this.added;
    }

    public boolean isEmpty() {
        return this.added == 0;
    }

    public static String render(String[] array, String separator) {
        List<String> asList = Arrays.asList(array);
        return ListWriter.render(asList, separator);
    }

    public static String render(String[] array, String prefix, String elemPrefix, String elemSuffix, String separator, String lastSeparator, String suffix) {
        List<String> asList = Arrays.asList(array);
        return ListWriter.render(asList, prefix, elemPrefix, elemSuffix, separator, lastSeparator, suffix);
    }

    public static String render(Collection<String> collection, String separator) {
        return ListWriter.render(collection, "", "", "", separator, separator, "");
    }

    public static String render(Collection<String> collection, String elemPrefix, String elemSuffix, String separator) {
        return ListWriter.render(collection, "", elemPrefix, elemSuffix, separator, "");
    }

    public static String render(Collection<String> collection, String elemPrefix, String elemSuffix, String separator, String lastSeparator) {
        return ListWriter.render(collection, "", elemPrefix, elemSuffix, separator, lastSeparator, "");
    }

    public static String render(Collection<String> collection, String prefix, String elemPrefix, String elemSuffix, String separator, String suffix) {
        return ListWriter.render(collection, prefix, elemPrefix, elemSuffix, separator, separator, suffix);
    }

    public static String render(Collection<String> collection, String prefix, String elemPrefix, String elemSuffix, String separator, String lastSeparator, String suffix) {
        ListWriter r = new ListWriter(prefix, elemPrefix, elemSuffix, separator, lastSeparator, suffix);
        for (String e : collection) {
            r.add(e);
        }
        return r.toString();
    }
}

