/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.util;

import org.hotrod.runtime.util.SQLTable;

public class SQLField {
    private SQLTable table;
    private String fieldName;

    public SQLField(SQLTable table, String fieldName) {
        this.table = table;
        this.fieldName = fieldName;
    }

    public SQLField(String fieldName) {
        int p = fieldName.indexOf(".");
        if (p < 0) {
            this.table = null;
            this.fieldName = fieldName;
        } else {
            this.table = new SQLTable(fieldName.substring(0, p));
            this.fieldName = fieldName.substring(p + 1);
        }
    }

    public SQLField(SQLField field) {
        this.table = field.getTable();
        this.fieldName = field.getFieldName();
    }

    public SQLField(SQLTable table, SQLField field) {
        this.table = table;
        this.fieldName = field.getFieldName();
    }

    public String render() {
        if (this.table != null) {
            return (this.table.getAlias() != null ? this.table.getAlias() : this.table.getName()) + "." + this.fieldName;
        }
        return this.fieldName;
    }

    public SQLTable getTable() {
        return this.table;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public SQLField using(SQLTable alias) {
        if (alias.getName().equals(this.table.getName())) {
            return new SQLField(alias, this.fieldName);
        }
        throw new RuntimeException("Provided table alias does not correspond to field's table");
    }

    public String toString() {
        return this.render();
    }

    public static void main(String[] args) {
        SQLField f = new SQLField("a.b");
        SQLField f2 = new SQLField(new SQLTable("t"), "b");
        SQLField f3 = new SQLField(new SQLTable("t", "alias"), "b");
        System.out.println(f);
        System.out.println(f2);
        System.out.println(f3);
        System.out.println(f2.using(new SQLTable(new SQLTable("t", "alias"), "alias2")));
    }
}

