/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.interfaces;

import java.util.ArrayList;
import java.util.List;
import org.hotrod.runtime.util.ListWriter;

public class SQLRenderer {
    private SQLSegmentType segmentType;
    private ListWriter lw;
    private List<Object> paramValues;
    private List<Integer> paramTypes;

    public SQLRenderer(SQLSegmentType segmentType) {
        this.segmentType = segmentType;
        this.paramValues = new ArrayList<Object>();
        this.paramTypes = new ArrayList<Integer>();
        this.lw = new ListWriter(segmentType.separator);
    }

    public SQLRenderer(SQLSegmentType segmentType, SQLRenderer sr) {
        this.segmentType = segmentType;
        this.paramValues = sr.paramValues;
        this.paramTypes = sr.paramTypes;
        this.lw = new ListWriter(segmentType.separator);
    }

    public void add(Object value, String name, int jdbcType) {
        if (value != null) {
            this.lw.add(name + " = ?");
            this.paramValues.add(value);
            this.paramTypes.add(jdbcType);
        }
    }

    public String render() {
        return this.lw.getCount() > 0 ? this.segmentType.getPrefix() + this.lw.toString() : "";
    }

    public int getItemCount() {
        return this.lw.getCount();
    }

    public static Object[] getParamValues(SQLRenderer ... renderers) {
        ArrayList<Object> allValues = new ArrayList<Object>();
        for (SQLRenderer r : renderers) {
            allValues.addAll(r.paramValues);
        }
        Object[] values = new Object[allValues.size()];
        return allValues.toArray(values);
    }

    public static int[] getParamTypes(SQLRenderer ... renderers) {
        ArrayList<Integer> allTypes = new ArrayList<Integer>();
        for (SQLRenderer r : renderers) {
            allTypes.addAll(r.paramTypes);
        }
        int[] types = new int[allTypes.size()];
        int i = 0;
        for (Integer t : allTypes) {
            types[i++] = t;
        }
        return types;
    }

    public static enum SQLSegmentType {
        SET(" set ", ", "),
        WHERE(" where ", " and ");

        private String prefix;
        private String separator;

        private SQLSegmentType(String prefix, String separator) {
            this.prefix = prefix;
            this.separator = separator;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSeparator() {
            return this.separator;
        }
    }
}

