/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.dialects;

import org.hotrod.runtime.livesql.dialects.FunctionRenderer;
import org.hotrod.runtime.livesql.dialects.IdentifierRenderer;
import org.hotrod.runtime.livesql.dialects.JoinRenderer;
import org.hotrod.runtime.livesql.dialects.PaginationRenderer;
import org.hotrod.runtime.livesql.dialects.SetOperationRenderer;

public abstract class SQLDialect {
    private String databaseName;
    private String databaseVersion;
    private int databaseMajorVersion;
    private int databaseMinorVersion;

    protected SQLDialect(String databaseName, String databaseVersion, int databaseMajorVersion, int databaseMinorVersion) {
        this.databaseName = databaseName;
        this.databaseVersion = databaseVersion;
        this.databaseMajorVersion = databaseMajorVersion;
        this.databaseMinorVersion = databaseMinorVersion;
    }

    public String getProductName() {
        return this.databaseName;
    }

    public String getProductVersion() {
        return this.databaseVersion;
    }

    public int getMajorVersion() {
        return this.databaseMajorVersion;
    }

    public int getMinorVersion() {
        return this.databaseMinorVersion;
    }

    protected boolean versionIsAtLeast(int major, int minor) {
        return this.databaseMajorVersion > major || this.databaseMajorVersion == major && this.databaseMinorVersion >= minor;
    }

    protected boolean versionIsAtLeast(int major) {
        return this.databaseMajorVersion >= major;
    }

    protected String renderVersion() {
        return "" + this.databaseMajorVersion + "." + this.databaseMinorVersion + " (" + this.databaseVersion + ")";
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + (this.databaseName != null ? "databaseName=" + this.databaseName + ", " : "") + (this.databaseVersion != null ? "databaseVersion=" + this.databaseVersion + ", " : "") + "databaseMajorVersion=" + this.databaseMajorVersion + ", databaseMinorVersion=" + this.databaseMinorVersion + "]";
    }

    public abstract IdentifierRenderer getIdentifierRenderer();

    public abstract JoinRenderer getJoinRenderer();

    public abstract PaginationRenderer getPaginationRenderer();

    public abstract SetOperationRenderer getSetOperationRenderer();

    public abstract FunctionRenderer getFunctionRenderer();
}

