/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.dialects;

import java.util.Date;
import java.util.List;
import org.hotrod.runtime.livesql.dialects.FunctionRenderer;
import org.hotrod.runtime.livesql.dialects.IdentifierRenderer;
import org.hotrod.runtime.livesql.dialects.JoinRenderer;
import org.hotrod.runtime.livesql.dialects.PaginationRenderer;
import org.hotrod.runtime.livesql.dialects.SQLDialect;
import org.hotrod.runtime.livesql.dialects.SetOperationRenderer;
import org.hotrod.runtime.livesql.exceptions.InvalidLiveSQLStatementException;
import org.hotrod.runtime.livesql.exceptions.UnsupportedLiveSQLFeatureException;
import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.expressions.datetime.DateTimeFieldExpression;
import org.hotrod.runtime.livesql.expressions.numbers.NumberConstant;
import org.hotrod.runtime.livesql.ordering.OrderingTerm;
import org.hotrod.runtime.livesql.queries.select.CrossJoin;
import org.hotrod.runtime.livesql.queries.select.FullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.InnerJoin;
import org.hotrod.runtime.livesql.queries.select.Join;
import org.hotrod.runtime.livesql.queries.select.LeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalFullOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalInnerJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalLeftOuterJoin;
import org.hotrod.runtime.livesql.queries.select.NaturalRightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;
import org.hotrod.runtime.livesql.queries.select.RightOuterJoin;
import org.hotrod.runtime.livesql.queries.select.UnionJoin;
import org.hotrod.runtime.livesql.util.Separator;

public class SQLServerDialect
extends SQLDialect {
    public SQLServerDialect(String productName, String productVersion, int majorVersion, int minorVersion) {
        super(productName, productVersion, majorVersion, minorVersion);
    }

    @Override
    public IdentifierRenderer getIdentifierRenderer() {
        return new IdentifierRenderer("[a-zA-Z][a-zA-Z0-9_]*", "\"", "\"", false);
    }

    @Override
    public JoinRenderer getJoinRenderer() {
        return new JoinRenderer(){

            @Override
            public String renderJoinKeywords(Join join) throws UnsupportedLiveSQLFeatureException {
                if (join instanceof InnerJoin) {
                    return "JOIN";
                }
                if (join instanceof LeftOuterJoin) {
                    return "LEFT OUTER JOIN";
                }
                if (join instanceof RightOuterJoin) {
                    return "RIGHT OUTER JOIN";
                }
                if (join instanceof FullOuterJoin) {
                    return "FULL OUTER JOIN";
                }
                if (join instanceof CrossJoin) {
                    return "CROSS JOIN";
                }
                if (join instanceof NaturalInnerJoin) {
                    return "NATURAL JOIN";
                }
                if (join instanceof NaturalLeftOuterJoin) {
                    return "NATURAL LEFT OUTER JOIN";
                }
                if (join instanceof NaturalRightOuterJoin) {
                    return "NATURAL RIGHT OUTER JOIN";
                }
                if (join instanceof NaturalFullOuterJoin) {
                    return "NATURAL FULL OUTER JOIN";
                }
                if (join instanceof UnionJoin) {
                    throw new UnsupportedLiveSQLFeatureException("Union joins are not supported in SQL Server database");
                }
                throw new UnsupportedLiveSQLFeatureException("Invalid join type (" + join.getClass().getSimpleName() + ") in SQL Server database");
            }
        };
    }

    @Override
    public PaginationRenderer getPaginationRenderer() {
        return new PaginationRenderer(){

            @Override
            public PaginationRenderer.PaginationType getPaginationType(Integer offset, Integer limit) {
                if (offset != null && !SQLServerDialect.this.versionIsAtLeast(11)) {
                    throw new UnsupportedLiveSQLFeatureException("OFFSET not supported on this version of SQL Server. OFFSET is supported starting on SQL Server 2012 (internal version 11.0)");
                }
                return SQLServerDialect.this.versionIsAtLeast(11) ? PaginationRenderer.PaginationType.BOTTOM : PaginationRenderer.PaginationType.TOP;
            }

            @Override
            public void renderTopPagination(Integer offset, Integer limit, QueryWriter w) {
                if (offset != null || SQLServerDialect.this.versionIsAtLeast(11)) {
                    throw new UnsupportedLiveSQLFeatureException("In SQL Server before version 2012, LIMIT can only be used without OFFSET as the TOP clause");
                }
                w.write(" top " + limit);
            }

            @Override
            public void renderBottomPagination(Integer offset, Integer limit, QueryWriter w) {
                if (offset != null) {
                    w.write("\nOFFSET " + offset + " ROWS");
                } else if (limit != null) {
                    w.write("\nOFFSET 0 ROWS");
                }
                if (limit != null) {
                    w.write("FETCH NEXT " + limit + " ROWS ONLY");
                }
            }

            @Override
            public void renderBeginEnclosingPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("Pagination cannot be rendered in enclosing fashion in SQL Server");
            }

            @Override
            public void renderEndEnclosingPagination(Integer offset, Integer limit, QueryWriter w) {
                throw new UnsupportedLiveSQLFeatureException("Pagination cannot be rendered in enclosing fashion in SQL Server");
            }
        };
    }

    @Override
    public SetOperationRenderer getSetOperationRenderer() {
        return new SetOperationRenderer(){

            @Override
            public void render(SetOperationRenderer.SetOperation setOperation, QueryWriter w) {
                switch (setOperation) {
                    case UNION: {
                        w.write("UNION");
                        break;
                    }
                    case UNION_ALL: {
                        w.write("UNION ALL");
                        break;
                    }
                    case INTERSECT: {
                        w.write("INTERSECT");
                        break;
                    }
                    case INTERSECT_ALL: {
                        throw new UnsupportedLiveSQLFeatureException("SQL Server does not support the INTERSECT ALL set operation. Nevertheless, it can be simulated using a semi join");
                    }
                    case EXCEPT: {
                        w.write("EXCEPT");
                        break;
                    }
                    case EXCEPT_ALL: {
                        throw new UnsupportedLiveSQLFeatureException("SQL Server does not support the EXCEPT ALL set operation. Nevertheless, it can be simulated using an anti join");
                    }
                    default: {
                        throw new InvalidLiveSQLStatementException("Invalid set operation '" + (Object)((Object)setOperation) + "'.");
                    }
                }
            }
        };
    }

    @Override
    public FunctionRenderer getFunctionRenderer() {
        return new FunctionRenderer(){

            @Override
            public void groupConcat(QueryWriter w, boolean distinct, Expression<String> value, List<OrderingTerm> ordering, Expression<String> separator) {
                if (SQLServerDialect.this.versionIsAtLeast(14)) {
                    throw new UnsupportedLiveSQLFeatureException("This SQL Server version (" + SQLServerDialect.this.renderVersion() + ") does not support the GROUP_CONCAT() function (string_agg()). It's available since version 14.0 (SQL Server 2017)");
                }
                if (distinct) {
                    throw new UnsupportedLiveSQLFeatureException("SQL Server does not support DISTINCT on the GROUP_CONCAT() function (string_agg())");
                }
                if (separator == null) {
                    throw new UnsupportedLiveSQLFeatureException("SQL Server requires the separator to be specified on the GROUP_CONCAT() function (string_agg())");
                }
                w.write("string_agg(");
                value.renderTo(w);
                w.write(", ");
                separator.renderTo(w);
                w.write(")");
                if (ordering != null && !ordering.isEmpty()) {
                    w.write(" within group (ORDER BY ");
                    Separator sep = new Separator();
                    for (OrderingTerm t : ordering) {
                        w.write(sep.render());
                        t.renderTo(w);
                    }
                }
                w.write(")");
            }

            @Override
            public void logarithm(QueryWriter w, Expression<Number> x, Expression<Number> base) {
                if (base == null) {
                    this.write(w, "log", x);
                } else {
                    this.write(w, "log", x, base);
                }
            }

            @Override
            public void round(QueryWriter w, Expression<Number> x, Expression<Number> places) {
                if (places == null) {
                    throw new UnsupportedLiveSQLFeatureException("SQL Server requires the number of decimal places to be specified on the ROUND() function");
                }
                this.write(w, "round", x, places);
            }

            @Override
            public void trunc(QueryWriter w, Expression<Number> x, Expression<Number> places) {
                if (places == null) {
                    throw new UnsupportedLiveSQLFeatureException("SQL Server requires the number of decimal places to be specified on the TRUNC() function (round())");
                }
                this.write(w, "round", x, places, new NumberConstant((Number)1));
            }

            @Override
            public void length(QueryWriter w, Expression<String> string) {
                this.write(w, "len", string);
            }

            @Override
            public void locate(QueryWriter w, Expression<String> substring, Expression<String> string, Expression<Number> from) {
                if (from == null) {
                    this.write(w, "charindex", substring, string);
                } else {
                    this.write(w, "charindex", substring, string, from);
                }
            }

            @Override
            public void substr(QueryWriter w, Expression<String> string, Expression<Number> from, Expression<Number> length) {
                if (length == null) {
                    throw new UnsupportedLiveSQLFeatureException("SQL Server requires the length parameter to be be specified on the SUBSTR() function");
                }
                this.write(w, "substring", string, from, length);
            }

            @Override
            public void currentDate(QueryWriter w) {
                w.write("getdate()");
            }

            @Override
            public void currentTime(QueryWriter w) {
                w.write("convert(time, current_timestamp)");
            }

            @Override
            public void currentDateTime(QueryWriter w) {
                w.write("current timestamp");
            }

            @Override
            public void date(QueryWriter w, Expression<Date> datetime) {
                w.write("convert(date, ");
                datetime.renderTo(w);
                w.write(")");
            }

            @Override
            public void time(QueryWriter w, Expression<Date> datetime) {
                w.write("convert(time, ");
                datetime.renderTo(w);
                w.write(")");
            }

            @Override
            public void dateTime(QueryWriter w, Expression<Date> date, Expression<Date> time) {
                w.write("(");
                date.renderTo(w);
                w.write(" + ");
                time.renderTo(w);
                w.write(")");
            }

            @Override
            public void extract(QueryWriter w, Expression<Date> datetime, DateTimeFieldExpression field) {
                w.write("datepart(");
                field.renderTo(w);
                w.write(", ");
                datetime.renderTo(w);
                w.write(")");
            }
        };
    }
}

