/*
 * Decompiled with CFR 0.152.
 */
package org.hotrod.runtime.livesql.expressions.aggregations;

import org.hotrod.runtime.livesql.expressions.Expression;
import org.hotrod.runtime.livesql.expressions.aggregations.AggregationFunction;
import org.hotrod.runtime.livesql.queries.select.AbstractSelect;
import org.hotrod.runtime.livesql.queries.select.QueryWriter;

public abstract class NonWindowableAggregationFunction<T>
extends AggregationFunction<T> {
    private String functionName;
    private String qualifier;
    protected Expression<?> expression;

    public NonWindowableAggregationFunction(String functionName, String qualifier, Expression<?> expression) {
        super(2);
        if (qualifier != null && expression == null) {
            throw new IllegalArgumentException("Invalid parameters on function '" + functionName + "': cannot specify '" + qualifier + "' clause without any expression");
        }
        this.functionName = functionName;
        this.qualifier = qualifier;
        this.expression = expression;
    }

    @Override
    public void renderTo(QueryWriter w) {
        this.renderHead(w);
        this.renderTail(w);
    }

    protected void renderHead(QueryWriter w) {
        w.write(this.functionName);
        w.write("(");
        if (this.qualifier != null) {
            w.write(this.qualifier);
        }
        if (this.qualifier != null && this.expression != null) {
            w.write(" ");
        }
        if (this.expression != null) {
            super.renderInner(this.expression, w);
        }
    }

    protected void renderTail(QueryWriter w) {
        w.write(")");
    }

    @Override
    public void validateTableReferences(AbstractSelect.TableReferences tableReferences, AbstractSelect.AliasGenerator ag) {
        this.expression.validateTableReferences(tableReferences, ag);
    }

    @Override
    public void designateAliases(AbstractSelect.AliasGenerator ag) {
        this.expression.designateAliases(ag);
    }
}

